/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IContactService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.types.Gender;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ContactService
implements IContactService {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;

    public List<IPerson> findPersonDuplicates(LocalDate dateOfBirth, Gender gender, String lastName, String firstName, boolean includeDeleted) {
        IQuery query = this.coreModelService.getQuery(IPerson.class, includeDeleted);
        query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__DATE_OF_BIRTH, IQuery.COMPARATOR.EQUALS, (Object)dateOfBirth);
        query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__GENDER, IQuery.COMPARATOR.EQUALS, (Object)gender);
        List execute = query.execute();
        ArrayList<IPerson> candidates = new ArrayList<IPerson>();
        execute.forEach(person -> {
            Integer firstNameDistance = Integer.MAX_VALUE;
            Integer lastNameDistance = Integer.MAX_VALUE;
            if (StringUtils.isNotBlank((CharSequence)firstName)) {
                firstNameDistance = LevenshteinDistance.getDefaultInstance().apply((CharSequence)person.getFirstName(), (CharSequence)firstName);
            }
            if (StringUtils.isNotBlank((CharSequence)lastName)) {
                lastNameDistance = LevenshteinDistance.getDefaultInstance().apply((CharSequence)person.getLastName(), (CharSequence)lastName);
            }
            if (firstNameDistance < 4 || lastNameDistance < 4) {
                candidates.add((IPerson)person);
            }
        });
        return candidates;
    }
}

