/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.vfs;

import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;

public class VirtualFilesystemServiceTest {
    IVirtualFilesystemService service = (IVirtualFilesystemService)OsgiServiceUtil.getService(IVirtualFilesystemService.class).get();

    @Test
    public void of_unixoid() throws IOException {
        File file = new File("/tmp/test.txt");
        Assert.assertEquals((Object)file, this.service.of("/tmp/test.txt").toFile().get());
        Assert.assertEquals((Object)file, this.service.of("//tmp/test.txt").toFile().get());
        Assert.assertEquals((Object)file, this.service.of("file:///tmp/test.txt").toFile().get());
    }

    @Test
    public void of_windows_share_UNC_Notation() throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle unc_handle = this.service.of("\\\\medeserv\\elexisdata\\folder_name");
        Assert.assertEquals((Object)new URL("smb://medeserv/elexisdata/folder_name"), (Object)unc_handle.toURL());
        IVirtualFilesystemService.IVirtualFilesystemHandle subDir = unc_handle.subDir("subdir");
        Assert.assertEquals((Object)"smb://medeserv/elexisdata/folder_name/subdir/", (Object)subDir.toURL().toString());
    }

    @Test
    public void of_windows_C_Notation() throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle handle = this.service.of("C:/Windows/Test/");
        Assert.assertEquals((Object)"file://C:/Windows/Test/", (Object)handle.toURL().toString());
        IVirtualFilesystemService.IVirtualFilesystemHandle subDir = handle.subDir("subdir");
        Assert.assertEquals((Object)"file://C:/Windows/Test/subdir/", (Object)subDir.toURL().toString());
    }

    @Test
    public void hidePasswordInUrlString() {
        String hidePasswordInUrlString = IVirtualFilesystemService.hidePasswordInUrlString((String)"smb://username:password@testsrv/share/folder");
        Assert.assertEquals((Object)"smb://username:***@testsrv/share/folder", (Object)hidePasswordInUrlString);
        hidePasswordInUrlString = IVirtualFilesystemService.hidePasswordInUrlString((String)"\\\\medeserv\\share\\folder");
        Assert.assertEquals((Object)"\\\\medeserv\\share\\folder", (Object)hidePasswordInUrlString);
        hidePasswordInUrlString = IVirtualFilesystemService.hidePasswordInUrlString((String)"C:/Windows/Test");
        Assert.assertEquals((Object)"C:/Windows/Test", (Object)hidePasswordInUrlString);
    }

    @Test
    public void parseHandlingWithSpaces() throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle dirWithSpace = this.service.of("C:\\Users\\mad\\Documents\\Arbeit\\Testing\\Omnivore\\Abstand mit\\");
        URL url = dirWithSpace.toURL();
        Assert.assertEquals((Object)new URL("file://C:/Users/mad/Documents/Arbeit/Testing/Omnivore/Abstand%20mit/"), (Object)url);
        IVirtualFilesystemService.IVirtualFilesystemHandle dirWithSpaceSubdir = dirWithSpace.subDir("1");
        url = dirWithSpaceSubdir.toURL();
        Assert.assertEquals((Object)new URL("file://C:/Users/mad/Documents/Arbeit/Testing/Omnivore/Abstand%20mit/1/"), (Object)url);
        dirWithSpace = this.service.of("C:\\Users\\mad\\Documents\\Arbeit\\Testing\\Omni  vore\\Abstand mit\\");
        url = dirWithSpace.toURL();
        Assert.assertEquals((Object)new URL("file://C:/Users/mad/Documents/Arbeit/Testing/Omni%20%20vore/Abstand%20mit/"), (Object)url);
        dirWithSpaceSubdir = dirWithSpace.subDir("1");
        url = dirWithSpaceSubdir.toURL();
        Assert.assertEquals((Object)new URL("file://C:/Users/mad/Documents/Arbeit/Testing/Omni%20%20vore/Abstand%20mit/1/"), (Object)url);
    }
}

