/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.vfs;

import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.vfs.AbstractVirtualFileHandleTest;
import ch.elexis.core.services.vfs.VirtualFilesystemServiceTestUtil;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class VirtualFileHandle_Combined_Test
extends AbstractVirtualFileHandleTest {
    private List<String> FILENAMES_TO_TEST = Arrays.asList("Microsoft Word - [130121]-Varizenabkl\u00e4rung Frau Muster NM.doc.pdf", "Microsoft Word - [#130121]-Varizenabkl\u00e4rung Frau Muster NM.doc.pdf", "M\u00fcnlar Knut 9.2.1746 Bescheinigung.pdf", "PF_27245_17491.pdf Schnaitar ranh.pdf", "[Schopl Rbdssea 3 #178151]-Coloskopie_19100224.pdf", "[Schopl Rbdssea 3 178151]-Coloskopie_19100224.pdf", "2021-03-15-11-43-59-1.pdf", "[#75503]-Bericht Dr.BELLI 1.3.21-1.pdf", "Bericht_'Operationsbericht_Viszeralchirurgie_vom_26.02.2021'_f\u00fcr_Calogero_Miraglia_Fagiano.pdf");

    @BeforeClass
    public static void beforeClass() throws IOException {
        service = (IVirtualFilesystemService)OsgiServiceUtil.getService(IVirtualFilesystemService.class).get();
        tempDirectory = Files.createTempDirectory("virtualFilesystemTest_combined", new FileAttribute[0]);
        testDirectory = new File(tempDirectory.toFile(), "subDir/");
        Assert.assertTrue((boolean)testDirectory.mkdir());
        testDirectory.deleteOnExit();
        testHandle = service.of(testDirectory);
        Assert.assertTrue((boolean)testHandle.isDirectory());
    }

    @AfterClass
    public static void afterClass() throws IOException {
        FileUtils.deleteDirectory((File)tempDirectory.toFile());
    }

    @Test
    public void copyFromFileToSmb() throws IOException {
        Assume.assumeTrue((boolean)VirtualFilesystemServiceTestUtil.serviceIsReachable());
        System.out.println(tempDirectory.toFile());
        IVirtualFilesystemService.IVirtualFilesystemHandle remoteSubDir = service.of(VirtualFilesystemServiceTestUtil.PREFIX_AUTH_SAMBA).subDir("combined-test");
        IVirtualFilesystemService.IVirtualFilesystemHandle _remoteSubDir = remoteSubDir.mkdir();
        for (String filename : this.FILENAMES_TO_TEST) {
            File testFile = new File(testDirectory, filename);
            Files.write(testFile.toPath(), "meaninglessTestTextThatProvidesSomeContent".getBytes(), StandardOpenOption.CREATE);
            IVirtualFilesystemService.IVirtualFilesystemHandle source = service.of(testFile);
            IVirtualFilesystemService.IVirtualFilesystemHandle target = _remoteSubDir.subFile(filename);
            IVirtualFilesystemService.IVirtualFilesystemHandle _target = source.copyTo(target);
            Assert.assertTrue((boolean)_target.exists());
            Assert.assertEquals((Object)filename, (Object)_target.getName());
            String _loadedString = String.valueOf(VirtualFilesystemServiceTestUtil.PREFIX_AUTH_SAMBA) + "combined-test/" + filename;
            IVirtualFilesystemService.IVirtualFilesystemHandle _loaded = service.of(_loadedString);
            Assert.assertTrue((String)_loaded.toURL().toString(), (boolean)_loaded.exists());
            Assert.assertEquals((Object)filename, (Object)_loaded.getName());
            Assert.assertTrue((boolean)_target.canRead());
            _target.delete();
            Assert.assertFalse((boolean)_target.exists());
        }
    }
}

