/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IContactBuilder;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IXidService;
import ch.elexis.core.test.initializer.TestDatabaseInitializer;
import ch.elexis.core.types.Gender;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.time.LocalDate;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class IXidServiceTest
extends AbstractServiceTest {
    private IXidService service = (IXidService)OsgiServiceUtil.getService(IXidService.class).get();

    @Test
    public void addAndFindXids() {
        TestDatabaseInitializer.getXidService().localRegisterXIDDomainIfNotExists("domain", "domain", 1);
        IPatient patient = (IPatient)new IContactBuilder.PatientBuilder(coreModelService, "first", "last", LocalDate.now(), Gender.FEMALE).buildAndSave();
        this.service.addXid((Identifiable)patient, "domain", "domainId", true);
        List xids = this.service.getXids((Identifiable)patient);
        Assert.assertEquals((Object)"domainId", (Object)((IXid)xids.get(0)).getDomainId());
        Assert.assertEquals((Object)"first", (Object)((IPatient)this.service.findObject("domain", "domainId", IPatient.class).get()).getFirstName());
        coreModelService.remove((Identifiable)patient);
        INamedQuery query = coreModelService.getNamedQuery(IXid.class, new String[]{"objectid"});
        xids = query.executeWithParameters(query.getParameterMap(new Object[]{"objectid", patient.getId()}));
        Assert.assertEquals((long)1L, (long)xids.size());
        coreModelService.remove((Identifiable)xids.get(0));
    }

    @Test
    public void addAndDeleteIncludingXids() {
        TestDatabaseInitializer.getXidService().localRegisterXIDDomainIfNotExists("domain", "domain", 1);
        IPatient patient = (IPatient)new IContactBuilder.PatientBuilder(coreModelService, "first", "last", LocalDate.now(), Gender.FEMALE).buildAndSave();
        this.service.addXid((Identifiable)patient, "domain", "domainId", true);
        INamedQuery query = coreModelService.getNamedQuery(IXid.class, new String[]{"objectid"});
        List xids = query.executeWithParameters(query.getParameterMap(new Object[]{"objectid", patient.getId()}));
        Assert.assertEquals((long)1L, (long)xids.size());
        coreModelService.delete((Deleteable)patient);
        query = coreModelService.getNamedQuery(IXid.class, new String[]{"objectid"});
        xids = query.executeWithParameters(query.getParameterMap(new Object[]{"objectid", patient.getId()}));
        Assert.assertEquals((long)0L, (long)xids.size());
    }
}

