/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.IUserService;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IUserServiceTest
extends AbstractServiceTest {
    private IUserService service = (IUserService)OsgiServiceUtil.getService(IUserService.class).get();
    private IUser user;

    @Before
    public void before() {
        this.createTestMandantPatientFallBehandlung();
        this.user = coreModelService.load("user", IUser.class).orElse(null);
        this.user.getAssignedContact().setExtInfo((Object)"StdMandant", (Object)((IMandator)this.testMandators.get(0)).getId());
        this.user.getAssignedContact().setExtInfo((Object)"Mandant", (Object)((IMandator)this.testMandators.get(0)).getLabel());
        coreModelService.save((Identifiable)this.user.getAssignedContact());
    }

    @After
    public void after() {
        this.cleanup();
    }

    @Test
    public void userLoadChangeVerifyPassword() {
        Assert.assertNotNull((Object)this.user.getHashedPassword());
        Assert.assertNotNull((Object)this.user.getSalt());
        List roles = this.user.getRoles();
        Assert.assertNotNull((Object)roles);
        Assert.assertEquals((Object)"user", (Object)((IRole)roles.iterator().next()).getId());
        Assert.assertFalse((boolean)this.service.verifyPassword(this.user, "invalid".toCharArray()));
        this.service.setPasswordForUser(this.user, "password");
        Assert.assertTrue((boolean)this.service.verifyPassword(this.user, "password".toCharArray()));
        Optional userRole = coreModelService.load("user", IRole.class);
        Assert.assertTrue((boolean)this.user.getRoles().contains(userRole.get()));
    }

    @Test
    public void getExecutiveDoctorsWorkingFor() {
        Set executiveDoctorsWorkingFor = this.service.getExecutiveDoctorsWorkingFor(this.user.getAssignedContact());
        Assert.assertEquals(this.testMandators.get(0), executiveDoctorsWorkingFor.iterator().next());
    }

    @Test
    public void getDefaultExecutiveDoctorWorkingFor() {
        Optional defaultExecutiveDoctorWorkingFor = this.service.getDefaultExecutiveDoctorWorkingFor(this.user.getAssignedContact());
        Assert.assertEquals(this.testMandators.get(0), defaultExecutiveDoctorWorkingFor.get());
    }

    @Test
    public void setRoles() {
        List roles = this.user.getRoles();
        Assert.assertEquals((long)2L, (long)roles.size());
        List _roles = this.user.getRoles().stream().map(r -> r.getId()).collect(Collectors.toList());
        Assert.assertTrue((boolean)_roles.contains("user"));
        Assert.assertTrue((boolean)_roles.contains("doctor"));
        this.service.setUserRoles(this.user, Collections.singleton("user"));
        Assert.assertEquals((Object)"user", (Object)((IRole)this.user.getRoles().get(0)).getId());
        HashSet<String> totalUserRoles = new HashSet<String>();
        totalUserRoles.add("user");
        totalUserRoles.add("doctor");
        this.service.setUserRoles(this.user, totalUserRoles);
    }
}

