/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.builder.IAppointmentBuilder;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.AllServiceTests;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.ITextReplacementService;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.time.LocalDateTime;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ITextReplacementServiceTest
extends AbstractServiceTest {
    private ITextReplacementService textReplacementService = (ITextReplacementService)OsgiServiceUtil.getService(ITextReplacementService.class).get();
    private IContextService contextService = (IContextService)OsgiServiceUtil.getService(IContextService.class).get();
    private static IAppointment appointment;

    @BeforeClass
    public static void beforeClass() {
        LocalDateTime ldt = LocalDateTime.of(2019, 12, 12, 12, 12);
        appointment = (IAppointment)new IAppointmentBuilder(coreModelService, "testSchedule", ldt, ldt.plusHours(1L), "type", "state").buildAndSave();
    }

    @Test
    public void patientReplacement() {
        this.contextService.setActivePatient(AllServiceTests.getPatient());
        String template = "Hallo [Patient.Name] [Patient.Vorname]";
        String replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"Hallo Patient Test", (Object)replaced);
    }

    @Test
    public void terminReplacement() {
        this.contextService.getRootContext().setTyped((Object)appointment);
        String template = "[Termin.Tag] [Termin.zeit] [Termin.Bereich]";
        String replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"12.12.2019 12:12 testSchedule", (Object)replaced);
    }
}

