/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IBlob;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IContactBuilder;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.Gender;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class IConfigServiceTest
extends AbstractServiceTest {
    private IConfigService configService = (IConfigService)OsgiServiceUtil.getService(IConfigService.class).get();

    @Test
    public void testUserConfigBlob() {
        IPerson person = (IPerson)new IContactBuilder.PersonBuilder(coreModelService, "TestPerson", "TestPerson", LocalDate.now(), Gender.FEMALE).mandator().buildAndSave();
        this.configService.set((IContact)person, "test/userconfig", true);
        this.configService.set((IContact)person, "test/user", person.getLabel());
        Map configMap = this.configService.getAsMap((IContact)person);
        Assert.assertEquals((Object)"1", ((Map)configMap.get("test")).get("userconfig"));
        Assert.assertEquals((Object)person.getLabel(), ((Map)configMap.get("test")).get("user"));
        IBlob blob = (IBlob)CoreModelServiceHolder.get().create(IBlob.class);
        blob.setId("UserCfg:test");
        blob.setMapContent(configMap);
        CoreModelServiceHolder.get().save((Identifiable)blob);
        this.configService.set((IContact)person, "test/userconfig", null);
        this.configService.set((IContact)person, "test/user", null);
        Assert.assertFalse((boolean)this.configService.get((IContact)person, "test/userconfig", false));
        Map map = blob.getMapContent();
        this.configService.setFromMap((IContact)person, map);
        Assert.assertTrue((boolean)this.configService.get((IContact)person, "test/userconfig", false));
        Assert.assertEquals((Object)person.getLabel(), (Object)this.configService.get((IContact)person, "test/user", ""));
    }

    @Test
    public void testUserConfigBlobCompatibility() throws IOException {
        IPerson person = (IPerson)new IContactBuilder.PersonBuilder(coreModelService, "TestPerson", "TestPerson", LocalDate.now(), Gender.FEMALE).mandator().buildAndSave();
        IBlob blob = (IBlob)CoreModelServiceHolder.get().create(IBlob.class);
        blob.setId("UserCfg:test");
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream in = IConfigServiceTest.class.getResourceAsStream("/rsc/usrcfg.blob");){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            blob.setContent(out.toByteArray());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertNotEquals((Object)"1", (Object)this.configService.get((IContact)person, "ch.elexis.omnivore//savesortdirection", ""));
        Map blobMap = blob.getMapContent();
        this.configService.setFromMap((IContact)person, blobMap);
        Assert.assertEquals((Object)"1", (Object)this.configService.get((IContact)person, "ch.elexis.omnivore//savesortdirection", ""));
        Assert.assertEquals((Object)"Allgemein", (Object)this.configService.get((IContact)person, "fall/std_label", ""));
        Map configMap = this.configService.getAsMap((IContact)person);
        Assert.assertTrue((boolean)this.mapsContentEquals(blobMap, configMap));
        Assert.assertEquals((Object)"1", ((Map)((Map)configMap.get("ch.elexis.omnivore")).get("")).get("savesortdirection"));
    }

    private boolean mapsContentEquals(Map<Object, Object> left, Map<Object, Object> right) {
        for (Object key : left.keySet()) {
            if (left.get(key) instanceof Map) {
                if (this.mapsContentEquals((Map)left.get(key), (Map)right.get(key))) continue;
                return false;
            }
            if (left.get(key).equals(right.get(key))) continue;
            System.out.println("key [" + key + "] left [" + left.get(key) + "] right [" + right.get(key) + "]");
            return false;
        }
        return true;
    }

    @Test
    public void getSetUserconfig() {
        IPerson person = (IPerson)new IContactBuilder.PersonBuilder(coreModelService, "TestPerson", "TestPerson", LocalDate.now(), Gender.FEMALE).mandator().buildAndSave();
        IPerson person2 = (IPerson)new IContactBuilder.PersonBuilder(coreModelService, "TestPerson2", "TestPerson2", LocalDate.now(), Gender.FEMALE).mandator().buildAndSave();
        Assert.assertTrue((boolean)this.configService.set((IContact)person, "key", "value"));
        Assert.assertTrue((boolean)this.configService.set((IContact)person2, "key", "value2"));
        Assert.assertEquals((Object)"value", (Object)this.configService.get((IContact)person, "key", null));
        Assert.assertEquals((Object)"value2", (Object)this.configService.get((IContact)person2, "key", null));
        Assert.assertTrue((boolean)this.configService.set((IContact)person, "key", null));
        Assert.assertNull((Object)this.configService.get((IContact)person, "key", null));
        Assert.assertFalse((boolean)this.configService.set((IContact)person, "key", null));
    }

    @Test
    public void getSetConfig() {
        Assert.assertTrue((boolean)this.configService.set("key", "value"));
        Assert.assertEquals((Object)"value", (Object)this.configService.get("key", null));
        Assert.assertTrue((boolean)this.configService.set("key", null));
        Assert.assertFalse((boolean)this.configService.set("key", null));
    }

    @Test
    public void getOrInsert() {
        Assert.assertNull((Object)this.configService.get("getOrInsert", null));
        Assert.assertEquals((Object)"1234567890abcde", (Object)this.configService.getOrInsert(null, "getOrInsert", () -> "1234567890abcde"));
        Assert.assertEquals((Object)"1234567890abcde", (Object)this.configService.getOrInsert(null, "getOrInsert", () -> "fghijklmnopqrst"));
    }

    @Test
    public void getOrInsertContact() {
        IPerson person = (IPerson)new IContactBuilder.PersonBuilder(coreModelService, "TestPersonGetOrInsert", "TestPersonGetOrInsert", LocalDate.now(), Gender.FEMALE).mandator().buildAndSave();
        Assert.assertNull((Object)this.configService.get((IContact)person, "getOrInsert", null));
        Assert.assertEquals((Object)"1234567890abcde", (Object)this.configService.getOrInsert((IContact)person, "getOrInsert", () -> "1234567890abcde"));
        Assert.assertEquals((Object)"1234567890abcde", (Object)this.configService.getOrInsert((IContact)person, "getOrInsert", () -> "fghijklmnopqrst"));
    }

    @Test
    public void getSetAsList() {
        String TEST_KEY_SET = "TestKeySet";
        List<String> values = Arrays.asList("TestValue", "TestValue2", "TestValue3");
        this.configService.set(TEST_KEY_SET, null);
        this.configService.setFromList(TEST_KEY_SET, values);
        List asSet = this.configService.getAsList(TEST_KEY_SET, Collections.emptyList());
        Assert.assertEquals((long)3L, (long)asSet.size());
        Assert.assertTrue((boolean)asSet.contains("TestValue"));
        Assert.assertTrue((boolean)asSet.contains("TestValue2"));
        Assert.assertTrue((boolean)asSet.contains("TestValue3"));
    }

    @Test
    public void getSetBoolean() {
        this.configService.set("keyBoolA", "1");
        this.configService.set("keyBoolB", "true");
        this.configService.set("keyBoolC", "bla");
        this.configService.set("keyBoolD", "0");
        this.configService.set("keyBoolE", "false");
        Assert.assertTrue((boolean)this.configService.get("keyBoolA", false));
        Assert.assertTrue((boolean)this.configService.get("keyBoolB", false));
        Assert.assertFalse((boolean)this.configService.get("keyBoolC", true));
        Assert.assertFalse((boolean)this.configService.get("keyBoolD", true));
        Assert.assertFalse((boolean)this.configService.get("keyBoolE", true));
    }

    @Test
    public void setWithWithoutTrace() throws InterruptedException {
        Assert.assertTrue((boolean)this.configService.set("asdfkeyWoTrace", "valueNoTrace", false));
        Assert.assertTrue((boolean)this.configService.set("asdfkeyWTrace", "valueTrace", true));
        String insertStatement = "SELECT action FROM TRACES WHERE action LIKE '%asdfkeyW%'";
        int i = 0;
        while (i < 10) {
            List traces = coreModelService.executeNativeQuery(insertStatement).map(o -> o.toString()).collect(Collectors.toList());
            if (traces.size() > 0) {
                Assert.assertEquals((long)1L, (long)traces.size());
                Assert.assertTrue((boolean)((String)traces.get(0)).startsWith("W globalCfg key [asdfkeyWTrace"));
                return;
            }
            Thread.sleep(100L);
            ++i;
        }
        Assert.fail((String)"could not find trace");
    }
}

