/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.services.internal.dto.CategoryDocumentDTO;
import ch.elexis.core.types.DocumentStatus;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BriefDocumentStoreTest
extends AbstractServiceTest {
    static IDocumentStore iDocumentStore;

    @Before
    public void before() {
        Optional documentService = OsgiServiceUtil.getService(IDocumentStore.class, (String)"(storeid=ch.elexis.data.store.brief)");
        iDocumentStore = (IDocumentStore)documentService.orElseThrow(() -> new IllegalStateException("No service available"));
        this.createTestMandantPatientFallBehandlung();
    }

    @After
    public void after() {
        this.cleanup();
        OsgiServiceUtil.ungetService((Object)iDocumentStore);
    }

    @Test
    public void testCrudAndSearchDocuments() throws IOException, ElexisException {
        IPatient iPatient = (IPatient)this.testPatients.get(0);
        IDocumentLetter letter = (IDocumentLetter)coreModelService.create(IDocumentLetter.class);
        letter.setPatient(iPatient);
        letter.setDescription("Test desc");
        letter.setMimeType("docx");
        letter.setTitle("Test Brief");
        letter.setCategory((ICategory)new CategoryDocumentDTO("Rechnung"));
        letter.setEncounter((IEncounter)this.testEncounters.get(0));
        letter.setContent(this.getClass().getResourceAsStream("/rsc/Testdocument.docx"));
        iDocumentStore.saveDocument((IDocument)letter);
        Assert.assertEquals((long)0L, (long)iDocumentStore.getDocuments("WRONG ID", null, null, null).size());
        List documents = iDocumentStore.getDocuments(iPatient.getId(), null, null, null);
        Assert.assertEquals((long)1L, (long)documents.size());
        IDocumentLetter persistedDocument = (IDocumentLetter)documents.get(0);
        Assert.assertTrue((persistedDocument.getId() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Test Brief", (Object)persistedDocument.getTitle());
        Assert.assertEquals((Object)"docx", (Object)persistedDocument.getMimeType());
        Assert.assertEquals((Object)"Test desc", (Object)persistedDocument.getDescription());
        Assert.assertEquals((Object)"Rechnung", (Object)persistedDocument.getCategory().getName());
        Assert.assertEquals(Collections.singletonList(DocumentStatus.NEW), (Object)persistedDocument.getStatus());
        Assert.assertEquals((long)5554L, (long)persistedDocument.getContentLength());
        Assert.assertEquals(this.testEncounters.get(0), (Object)persistedDocument.getEncounter());
        iDocumentStore.saveDocument((IDocument)persistedDocument, IOUtils.toInputStream((String)"test"));
        documents = iDocumentStore.getDocuments(iPatient.getId(), null, (ICategory)new CategoryDocumentDTO("Bestellung"), null);
        Assert.assertEquals((long)0L, (long)documents.size());
        documents = iDocumentStore.getDocuments(iPatient.getId(), null, (ICategory)new CategoryDocumentDTO("Rechnung"), null);
        Assert.assertEquals((long)1L, (long)documents.size());
        persistedDocument = (IDocumentLetter)documents.get(0);
        Assert.assertTrue((persistedDocument.getId() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Test Brief", (Object)persistedDocument.getTitle());
        Optional in = iDocumentStore.loadContent((IDocument)persistedDocument);
        Assert.assertTrue((boolean)in.isPresent());
        String s = IOUtils.toString((InputStream)((InputStream)in.get()));
        Assert.assertEquals((Object)"test", (Object)s);
        Assert.assertEquals((long)1L, (long)iDocumentStore.getDocuments(iPatient.getId(), null, null, null).size());
        iDocumentStore.removeDocument((IDocument)persistedDocument);
        Assert.assertEquals((long)0L, (long)iDocumentStore.getDocuments(iPatient.getId(), null, null, null).size());
    }
}

