/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.ac.AccessControlDefaults;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IRight;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.AllServiceTests;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.internal.RoleBasedAccessControlTestACLContribution;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AccessControlServiceTest {
    private IModelService modelService = AllServiceTests.getModelService();
    private static IAccessControlService accessControlService;

    @BeforeClass
    public static void beforeClass() {
        accessControlService = (IAccessControlService)OsgiServiceUtil.getService(IAccessControlService.class).get();
        accessControlService.initializeDefaults();
    }

    @Test
    public void testInitialState() {
        List allSystemRights = this.modelService.getQuery(IRight.class).execute();
        System.out.println("Rights set: " + allSystemRights.stream().map(r -> r.getLabel()).collect(Collectors.joining(",")));
        Assert.assertTrue((allSystemRights.size() >= 40 ? 1 : 0) != 0);
        IUser user = (IUser)this.modelService.load("user", IUser.class).get();
        Assert.assertNotNull((String)"User Administrator is null", (Object)user);
        IContact assignedContact = user.getAssignedContact();
        Assert.assertNotNull((String)"No contact associated to user administrator", (Object)assignedContact);
        boolean queryRightForUser = accessControlService.request(user, AccessControlDefaults.AC_LOGIN);
        Assert.assertTrue((String)"Administrator is denied login", (boolean)queryRightForUser);
        List userUserRoles = user.getRoles();
        Assert.assertEquals((long)2L, (long)userUserRoles.size());
        List allSystemRoles = this.modelService.getQuery(IRole.class).execute();
        Assert.assertEquals((long)6L, (long)allSystemRoles.size());
        IRole userRole = (IRole)this.modelService.load("user", IRole.class).get();
        List userRoleAssignedRights = userRole.getAssignedRights();
        Assert.assertEquals((long)27L, (long)userRoleAssignedRights.size());
    }

    @Test
    public void testUserAddWithOKRight() {
        IUser user = (IUser)this.modelService.load("user", IUser.class).get();
        IRole ur = (IRole)this.modelService.load("user", IRole.class).get();
        Assert.assertNotNull((Object)ur);
        List assignedRoles = user.getRoles();
        boolean userHasRole = false;
        for (IRole role : assignedRoles) {
            if (!ur.getId().equals(role.getId())) continue;
            userHasRole = true;
        }
        Assert.assertTrue((String)assignedRoles.toString(), (boolean)userHasRole);
        boolean roleHasRight = accessControlService.request(ur, AccessControlDefaults.AC_EXIT);
        Assert.assertTrue((boolean)roleHasRight);
        boolean userHasRight = accessControlService.request(user, AccessControlDefaults.AC_EXIT);
        Assert.assertTrue((boolean)userHasRight);
    }

    @Test
    public void testUserAddWithNonOKRight() {
        IUser user = (IUser)this.modelService.load("user", IUser.class).get();
        boolean rightFalse = accessControlService.request(user, AccessControlDefaults.ADMIN_ACE);
        Assert.assertFalse((boolean)rightFalse);
    }

    @Test
    public void testUserAddAndRevokeParentRightInvolvesChildRights() {
        IUser user = (IUser)this.modelService.load("user", IUser.class).get();
        IRole userRole = (IRole)this.modelService.load("user", IRole.class).get();
        accessControlService.grant(userRole, RoleBasedAccessControlTestACLContribution.parent);
        boolean rightTrue = accessControlService.request(user, RoleBasedAccessControlTestACLContribution.child1child1);
        Assert.assertTrue((boolean)rightTrue);
        accessControlService.revoke(userRole, RoleBasedAccessControlTestACLContribution.parent);
        boolean rightFalse = accessControlService.request(user, RoleBasedAccessControlTestACLContribution.child1child1);
        Assert.assertFalse((boolean)rightFalse);
    }
}

