/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.java;

import com.wstutorial.ws.HelloWorld;
import com.wstutorial.ws.HelloWorldImpl;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Service;
import org.junit.Assert;
import org.junit.Test;

public class JaxWsTest {
    @Test
    public void jaxwsFunctionality() throws MalformedURLException {
        System.setProperty("javax.xml.ws.spi.Provider", "com.sun.xml.ws.spi.ProviderImpl");
        Endpoint endpoint = Endpoint.publish((String)"http://localhost:14429/ws/helloworld", (Object)new HelloWorldImpl());
        Assert.assertTrue((boolean)endpoint.isPublished());
        Assert.assertEquals((Object)"http://schemas.xmlsoap.org/wsdl/soap/http", (Object)endpoint.getBinding().getBindingID());
        String namespaceURI = "http://ws.wstutorial.com/";
        String servicePart = "HelloWorldImplService";
        String portName = "HelloWorldImplPort";
        QName serviceQN = new QName(namespaceURI, servicePart);
        QName portQN = new QName(namespaceURI, portName);
        URL wsdlDocumentLocation = this.getClass().getResource("helloworld.wsdl.xml");
        Service service = Service.create((URL)wsdlDocumentLocation, (QName)serviceQN);
        HelloWorld testInterface = (HelloWorld)service.getPort(portQN, HelloWorld.class);
        Assert.assertEquals((Object)"Hello Junge !", (Object)testInterface.sayHelloWorld("Junge"));
        endpoint.stop();
        Assert.assertFalse((boolean)endpoint.isPublished());
    }
}

