/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.java;

import com.eclipsesource.jaxrs.consumer.ConsumerFactory;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JaxRsConsumerTest {
    private static HttpServer server;
    private static ThreadPoolExecutor executor;

    @BeforeClass
    public static void beforeClass() throws IOException {
        server = HttpServer.create(new InetSocketAddress("localhost", 0), 0);
        server.createContext("/test", new MyHttpHandler());
        executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(4);
        server.setExecutor(executor);
        server.start();
    }

    @AfterClass
    public static void afterClass() {
        server.stop(5);
        executor.shutdown();
    }

    @Test
    public void jaxrsFunctionality() {
        FakeResource resource = (FakeResource)ConsumerFactory.createConsumer((String)("http://localhost:" + server.getAddress().getPort()), FakeResource.class);
        Assert.assertEquals((Object)"get", (Object)resource.getContent());
        Assert.assertEquals((Object)"post", (Object)resource.postContent());
        Assert.assertEquals((Object)"put", (Object)resource.putContent(""));
        Assert.assertEquals((Object)"delete", (Object)resource.deleteContent());
    }

    @Path(value="/test")
    private static interface FakeResource {
        @GET
        public String getContent();

        @POST
        public String postContent();

        @POST
        public String postContent(String var1);

        @PUT
        public String putContent(String var1);

        @DELETE
        public String deleteContent();
    }

    private static class MyHttpHandler
    implements HttpHandler {
        private MyHttpHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String requestMethod = exchange.getRequestMethod();
            this.handleResponse(exchange, requestMethod.toLowerCase());
        }

        private void handleResponse(HttpExchange httpExchange, String requestParamValue) throws IOException {
            Throwable throwable = null;
            Object var4_5 = null;
            try (OutputStream outputStream = httpExchange.getResponseBody();){
                httpExchange.sendResponseHeaders(200, requestParamValue.length());
                outputStream.write(requestParamValue.getBytes());
                outputStream.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

