/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.Bestellung;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.model.OrderEntryState;
import ch.elexis.core.model.service.holder.CoreModelServiceHolder;
import ch.elexis.core.model.util.internal.ModelUtil;
import ch.rgw.tools.TimeTool;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class Order
extends AbstractIdDeleteModelAdapter<Bestellung>
implements IdentifiableWithXid,
IOrder {
    private static DateTimeFormatter timestampFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");

    public Order(Bestellung entity) {
        super((EntityWithId)entity);
    }

    public List<IOrderEntry> getEntries() {
        CoreModelServiceHolder.get().refresh((Identifiable)this);
        return ((Bestellung)this.getEntity()).getEntries().parallelStream().filter(b -> !b.isDeleted()).map(b -> ModelUtil.getAdapter((EntityWithId)b, IOrderEntry.class, true)).collect(Collectors.toList());
    }

    public IOrderEntry addEntry(IArticle article, IStock stock, IContact provider, int amount) {
        IOrderEntry orderEntry;
        String providerId;
        if (provider == null && (providerId = ModelUtil.getConfig("inventory/defaultArticleProvider", null)) != null) {
            IContact defProvider;
            provider = defProvider = ModelUtil.load(providerId, IContact.class);
        }
        if ((orderEntry = this.findOrderEntry(stock, article)) != null) {
            orderEntry.setAmount(orderEntry.getAmount() + amount);
            this.addChanged((Identifiable)orderEntry);
        } else {
            orderEntry = (IOrderEntry)ModelUtil.getModelService().create(IOrderEntry.class);
            orderEntry.setArticle(article);
            orderEntry.setStock(stock);
            orderEntry.setProvider(provider);
            orderEntry.setAmount(amount);
            orderEntry.setOrder((IOrder)this);
        }
        return orderEntry;
    }

    public IOrderEntry findOrderEntry(IStock stock, IArticle article) {
        List<IOrderEntry> entries = this.getEntries();
        for (IOrderEntry iOrderEntry : entries) {
            if ((iOrderEntry.getStock() != null || stock != null) && (iOrderEntry.getStock() == null || !iOrderEntry.getStock().equals(stock)) || !iOrderEntry.getArticle().equals(article)) continue;
            return iOrderEntry;
        }
        return null;
    }

    public LocalDateTime getTimestamp() {
        String[] parts;
        String id = this.getId();
        if (id != null && (parts = id.split(":")).length >= 2) {
            try {
                return LocalDateTime.parse(parts[1], timestampFormatter);
            }
            catch (DateTimeParseException e) {
                TimeTool tool = new TimeTool(parts[1]);
                return tool.toLocalDateTime();
            }
        }
        return null;
    }

    public void setTimestamp(LocalDateTime value) {
        this.updateId(value, this.getName());
    }

    public String getName() {
        String[] parts;
        String id = this.getId();
        if (id != null && id.contains(":") && (parts = id.split(":")).length >= 1) {
            return parts[0];
        }
        return "";
    }

    public void setName(String value) {
        this.updateId(this.getTimestamp(), value);
    }

    private void updateId(LocalDateTime timestamp, String name) {
        if (timestamp == null) {
            throw new IllegalStateException("Can not update id without timestamp");
        }
        Optional<IContact> activeUser = ModelUtil.getActiveUserContact();
        String id = String.valueOf(name != null ? name : "") + ":" + (timestamp != null ? timestamp.format(timestampFormatter) : "") + ":" + (activeUser.isPresent() ? activeUser.get().getId() : "");
        ((Bestellung)this.getEntityMarkDirty()).setId(id);
    }

    public boolean isDone() {
        for (IOrderEntry iOrderEntry : this.getEntries()) {
            if (iOrderEntry.getState() == OrderEntryState.DONE) continue;
            return false;
        }
        return true;
    }

    public boolean isPartialDone() {
        boolean foundDone = false;
        boolean foundNotDone = false;
        for (IOrderEntry iOrderEntry : this.getEntries()) {
            if (iOrderEntry.getState() == OrderEntryState.DONE) {
                foundDone = true;
                continue;
            }
            foundNotDone = true;
        }
        return foundDone && foundNotDone;
    }

    public String getLabel() {
        return String.valueOf(this.getName()) + ": " + DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm").format(this.getTimestamp());
    }
}

