/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IUserBuilder;
import ch.elexis.core.test.AbstractTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UserTest
extends AbstractTest {
    private IRole userRole;
    private IRole testRole;

    @Before
    public void before() {
        super.before();
        super.createPerson();
        this.userRole = (IRole)this.coreModelService.create(IRole.class);
        this.userRole.setSystemRole(true);
        this.userRole.setId("user");
        this.coreModelService.save((Identifiable)this.userRole);
        this.testRole = (IRole)this.coreModelService.create(IRole.class);
        this.testRole.setSystemRole(false);
        this.testRole.setId("testRole");
        this.coreModelService.save((Identifiable)this.testRole);
    }

    @After
    public void after() {
        this.coreModelService.remove((Identifiable)this.userRole);
        super.after();
    }

    @Test
    public void createFindRemove() {
        new IUserBuilder(this.coreModelService, "test", (IContact)this.person).buildAndSave();
        IUser user = (IUser)this.coreModelService.load("test", IUser.class).get();
        Assert.assertEquals((Object)"test", (Object)user.getUsername());
        Assert.assertEquals((Object)this.person.getId(), (Object)user.getAssignedContact().getId());
        Assert.assertTrue((boolean)user.getRoles().contains(this.coreModelService.load("user", IRole.class).get()));
        Assert.assertTrue((boolean)user.isActive());
        this.coreModelService.remove((Identifiable)user);
        Assert.assertFalse((boolean)this.coreModelService.load("test", IUser.class).isPresent());
    }

    @Test
    public void addRemoveRole() {
        IUser user = (IUser)new IUserBuilder(this.coreModelService, "test", (IContact)this.person).buildAndSave();
        Assert.assertFalse((boolean)user.getRoles().contains(this.testRole));
        Assert.assertTrue((boolean)user.getRoles().contains(this.userRole));
        user.addRole(this.testRole);
        this.coreModelService.save((Identifiable)user);
        user = (IUser)this.coreModelService.load(user.getId(), IUser.class).get();
        Assert.assertTrue((boolean)user.getRoles().contains(this.testRole));
        Assert.assertTrue((boolean)user.getRoles().contains(this.userRole));
        user.removeRole(this.testRole);
        this.coreModelService.save((Identifiable)user);
        user = (IUser)this.coreModelService.load(user.getId(), IUser.class).get();
        Assert.assertFalse((boolean)user.getRoles().contains(this.testRole));
        Assert.assertTrue((boolean)user.getRoles().contains(this.userRole));
    }
}

