/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.ITextTemplate;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.test.AbstractTest;
import ch.elexis.core.types.TextTemplateCategory;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextTemplateTest
extends AbstractTest {
    @Before
    public void before() {
        super.before();
        this.createMandator();
    }

    @After
    public void after() {
        super.after();
    }

    @Test
    public void create() {
        ITextTemplate template = (ITextTemplate)this.coreModelService.create(ITextTemplate.class);
        template.setCategory(TextTemplateCategory.MAIL);
        template.setMandator(this.mandator);
        template.setName("TestTemplate");
        template.setTemplate("Test Template\n[test.text]");
        this.coreModelService.save((Identifiable)template);
        Optional loaded = this.coreModelService.load(template.getId(), ITextTemplate.class);
        Assert.assertTrue((boolean)loaded.isPresent());
        Assert.assertFalse((template == loaded.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)template, loaded.get());
        Assert.assertEquals((Object)template.getMandator(), (Object)((ITextTemplate)loaded.get()).getMandator());
        Assert.assertEquals((Object)template.getCategory(), (Object)((ITextTemplate)loaded.get()).getCategory());
        Assert.assertEquals((Object)template.getName(), (Object)((ITextTemplate)loaded.get()).getName());
        Assert.assertEquals((Object)template.getTemplate(), (Object)((ITextTemplate)loaded.get()).getTemplate());
        this.coreModelService.remove((Identifiable)template);
    }

    @Test
    public void query() {
        ITextTemplate template = (ITextTemplate)this.coreModelService.create(ITextTemplate.class);
        template.setCategory(TextTemplateCategory.MAIL);
        template.setMandator(this.mandator);
        template.setName("TestTemplate");
        template.setTemplate("Test Template\n[test.text]");
        this.coreModelService.save((Identifiable)template);
        template = (ITextTemplate)this.coreModelService.create(ITextTemplate.class);
        template.setCategory(TextTemplateCategory.MAIL);
        template.setMandator(this.mandator);
        template.setName("TestTemplate1");
        template.setTemplate("Test Template1\n[test.text]");
        this.coreModelService.save((Identifiable)template);
        template = (ITextTemplate)this.coreModelService.create(ITextTemplate.class);
        template.setCategory(TextTemplateCategory.MAIL);
        template.setName("TestTemplate2");
        template.setTemplate("Test Template2\n[test.text]");
        this.coreModelService.save((Identifiable)template);
        IQuery query = this.coreModelService.getQuery(ITextTemplate.class);
        Assert.assertEquals((long)3L, (long)query.execute().size());
        query.and((EStructuralFeature)ModelPackage.Literals.ITEXT_TEMPLATE__MANDATOR, IQuery.COMPARATOR.EQUALS, (Object)this.mandator);
        Assert.assertEquals((long)2L, (long)query.execute().size());
        query = this.coreModelService.getQuery(ITextTemplate.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ITEXT_TEMPLATE__MANDATOR, IQuery.COMPARATOR.EQUALS, null);
        Assert.assertEquals((long)1L, (long)query.execute().size());
        query = this.coreModelService.getQuery(ITextTemplate.class);
        for (ITextTemplate found : query.execute()) {
            this.coreModelService.remove((Identifiable)found);
        }
    }
}

