/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.test.StoreToStringServiceHolder;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OrderEntryTest {
    private IModelService modelService;
    private IArticle article;
    private IArticle article1;
    private IStock stock;
    private IOrder order;
    private LocalDateTime orderTimestamp;

    @Before
    public void before() {
        this.modelService = (IModelService)OsgiServiceUtil.getService(IModelService.class, (String)"(service.model.name=ch.elexis.core.model)").get();
        this.article = (IArticle)this.modelService.create(IArticle.class);
        this.article.setName("test article");
        this.article.setCode("123456789");
        this.article.setTyp(ArticleTyp.EIGENARTIKEL);
        this.article.setGtin("0000001111111");
        this.article.setPackageSize(12);
        this.article.setSellingSize(12);
        this.modelService.save((Identifiable)this.article);
        this.article1 = (IArticle)this.modelService.create(IArticle.class);
        this.article1.setName("test article 1");
        this.article1.setCode("987654321");
        this.article1.setTyp(ArticleTyp.EIGENARTIKEL);
        this.article1.setGtin("1111112222222");
        this.article1.setPackageSize(24);
        this.article1.setSellingSize(24);
        this.modelService.save((Identifiable)this.article1);
        this.stock = (IStock)this.modelService.create(IStock.class);
        this.stock.setCode("TST");
        this.stock.setPriority(5);
        this.modelService.save((Identifiable)this.stock);
        this.orderTimestamp = LocalDateTime.now();
        this.order = (IOrder)this.modelService.create(IOrder.class);
        this.order.setTimestamp(this.orderTimestamp);
        this.order.setName("TEST");
        this.modelService.save((Identifiable)this.order);
    }

    @After
    public void after() {
        this.modelService.remove((Identifiable)this.order);
        this.modelService.remove((Identifiable)this.article);
        this.modelService.remove((Identifiable)this.article1);
        this.modelService.remove((Identifiable)this.stock);
        OsgiServiceUtil.ungetService((Object)this.modelService);
        this.modelService = null;
    }

    @Test
    public void create() {
        IOrderEntry entry = (IOrderEntry)this.modelService.create(IOrderEntry.class);
        Assert.assertNotNull((Object)entry);
        Assert.assertTrue((boolean)(entry instanceof IOrderEntry));
        entry.setOrder(this.order);
        entry.setStock(this.stock);
        entry.setArticle(this.article);
        entry.setAmount(5);
        this.modelService.save((Identifiable)entry);
        Assert.assertFalse((boolean)this.order.getEntries().isEmpty());
        Optional loaded = this.modelService.load(entry.getId(), IOrderEntry.class);
        Assert.assertTrue((boolean)loaded.isPresent());
        Assert.assertFalse((entry == loaded.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)entry, loaded.get());
        Assert.assertEquals((Object)entry.getArticle(), (Object)((IOrderEntry)loaded.get()).getArticle());
        Assert.assertEquals((Object)entry.getStock(), (Object)((IOrderEntry)loaded.get()).getStock());
        Assert.assertEquals((Object)entry.getOrder(), (Object)((IOrderEntry)loaded.get()).getOrder());
        Assert.assertEquals((Object)entry.getOrder().getTimestamp(), (Object)((IOrderEntry)loaded.get()).getOrder().getTimestamp());
        IOrderEntry entry2 = (IOrderEntry)this.modelService.create(IOrderEntry.class);
        entry2.setStock(this.stock);
        entry2.setArticle(this.article1);
        entry2.setAmount(1);
        entry2.setOrder(this.order);
        this.modelService.save((Identifiable)entry2);
        Assert.assertEquals((long)2L, (long)this.order.getEntries().size());
        IOrderEntry entry3 = this.order.addEntry(this.article1, this.stock, null, 3);
        this.modelService.save((Identifiable)entry3);
        Assert.assertEquals((long)4L, (long)entry3.getAmount());
        Assert.assertEquals((Object)entry2, (Object)entry3);
        this.modelService.remove((Identifiable)entry);
        this.modelService.remove((Identifiable)entry2);
        this.modelService.refresh((Identifiable)this.order, true);
        Assert.assertEquals((long)0L, (long)this.order.getEntries().size());
    }

    @Test
    public void query() {
        IOrderEntry entry = (IOrderEntry)this.modelService.create(IOrderEntry.class);
        entry.setOrder(this.order);
        entry.setStock(this.stock);
        entry.setArticle(this.article);
        entry.setAmount(5);
        this.modelService.save((Identifiable)entry);
        IOrderEntry entry1 = (IOrderEntry)this.modelService.create(IOrderEntry.class);
        entry1.setOrder(this.order);
        entry1.setStock(this.stock);
        entry1.setArticle(this.article1);
        entry1.setAmount(2);
        this.modelService.save((Identifiable)entry1);
        String storeToString = StoreToStringServiceHolder.getStoreToString(this.article);
        String[] articleParts = storeToString.split("::");
        IQuery query = this.modelService.getQuery(IOrderEntry.class, true, false);
        query.and("articleId", IQuery.COMPARATOR.EQUALS, (Object)articleParts[1]);
        query.and("articleType", IQuery.COMPARATOR.EQUALS, (Object)articleParts[0]);
        List existing = query.execute();
        Assert.assertEquals((long)1L, (long)existing.size());
        Assert.assertEquals((long)2L, (long)this.order.getEntries().size());
        Assert.assertEquals((long)2L, (long)((IOrderEntry)existing.get(0)).getOrder().getEntries().size());
        this.modelService.remove((Identifiable)entry);
        this.modelService.remove((Identifiable)entry1);
        this.modelService.refresh((Identifiable)this.order, true);
        Assert.assertEquals((long)0L, (long)this.order.getEntries().size());
    }
}

