/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabOrder;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.LabOrderState;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.test.AbstractTest;
import ch.elexis.core.types.LabItemTyp;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LabOrderTest
extends AbstractTest {
    private IPatient patient2;
    private ILabItem item1;
    private ILabResult result1;
    private ILabResult result2;

    @Before
    public void before() {
        super.before();
        super.createPatient();
        this.patient2 = (IPatient)this.coreModelService.create(IPatient.class);
        this.patient2.setDescription1("test patient 2");
        this.coreModelService.save((Identifiable)this.patient2);
        this.item1 = (ILabItem)this.coreModelService.create(ILabItem.class);
        this.item1.setCode("testItem");
        this.item1.setName("test item name");
        this.item1.setReferenceFemale("<25");
        this.item1.setReferenceMale("<30");
        this.item1.setTyp(LabItemTyp.NUMERIC);
        this.coreModelService.save((Identifiable)this.item1);
        this.result1 = (ILabResult)this.coreModelService.create(ILabResult.class);
        this.result1.setItem(this.item1);
        this.result1.setPatient(this.patient);
        this.result1.setResult("result 1");
        this.result2 = (ILabResult)this.coreModelService.create(ILabResult.class);
        this.result2.setItem(this.item1);
        this.result2.setPatient(this.patient2);
        this.result2.setResult("result 2");
    }

    @After
    public void after() {
        this.coreModelService.remove((Identifiable)this.result1);
        this.coreModelService.remove((Identifiable)this.result2);
        this.coreModelService.remove((Identifiable)this.item1);
        this.coreModelService.remove((Identifiable)this.patient2);
        super.after();
    }

    @Test
    public void create() {
        ILabOrder order = (ILabOrder)this.coreModelService.create(ILabOrder.class);
        Assert.assertNotNull((Object)order);
        Assert.assertTrue((boolean)(order instanceof ILabOrder));
        order.setItem(this.item1);
        order.setPatient(this.patient);
        order.setState(LabOrderState.ORDERED);
        this.coreModelService.save((Identifiable)order);
        Assert.assertNotNull((Object)order.getOrderId());
        Optional loadedOrder = this.coreModelService.load(order.getId(), ILabOrder.class);
        Assert.assertTrue((boolean)loadedOrder.isPresent());
        Assert.assertFalse((order == loadedOrder.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)order, loadedOrder.get());
        Assert.assertEquals((Object)order.getItem(), (Object)((ILabOrder)loadedOrder.get()).getItem());
        Assert.assertEquals((Object)order.getPatient(), (Object)((ILabOrder)loadedOrder.get()).getPatient());
        Assert.assertEquals((Object)order.getState(), (Object)((ILabOrder)loadedOrder.get()).getState());
        ILabOrder order1 = (ILabOrder)this.coreModelService.create(ILabOrder.class);
        order.setItem(this.item1);
        order.setPatient(this.patient);
        this.coreModelService.save((Identifiable)order1);
        Assert.assertEquals((long)1L, (long)(Integer.parseInt(order1.getOrderId()) - Integer.parseInt(order.getOrderId())));
        this.coreModelService.remove((Identifiable)order);
    }

    @Test
    public void query() {
        ILabOrder order1 = (ILabOrder)this.coreModelService.create(ILabOrder.class);
        order1.setItem(this.item1);
        order1.setPatient(this.patient);
        order1.setResult(this.result1);
        this.coreModelService.save((Identifiable)order1);
        ILabOrder order2 = (ILabOrder)this.coreModelService.create(ILabOrder.class);
        order2.setItem(this.item1);
        order2.setPatient(this.patient2);
        order2.setResult(this.result2);
        this.coreModelService.save((Identifiable)order2);
        IQuery query = this.coreModelService.getQuery(ILabOrder.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_ORDER__ITEM, IQuery.COMPARATOR.EQUALS, (Object)this.item1);
        List existing = query.execute();
        Assert.assertNotNull((Object)existing);
        Assert.assertFalse((boolean)existing.isEmpty());
        Assert.assertEquals((long)2L, (long)existing.size());
        query = this.coreModelService.getQuery(ILabOrder.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_ORDER__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)this.patient2);
        existing = query.execute();
        Assert.assertNotNull((Object)existing);
        Assert.assertFalse((boolean)existing.isEmpty());
        Assert.assertEquals((long)1L, (long)existing.size());
        Assert.assertFalse((order2 == existing.get(0) ? 1 : 0) != 0);
        Assert.assertEquals((Object)order2, existing.get(0));
        Assert.assertEquals((Object)order2.getPatient(), (Object)((ILabOrder)existing.get(0)).getPatient());
        Assert.assertEquals((Object)order1, (Object)this.result1.getLabOrder());
        this.coreModelService.remove((Identifiable)order1);
        this.coreModelService.remove((Identifiable)order2);
    }
}

