/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.ILabItemBuilder;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.test.AbstractTest;
import ch.elexis.core.types.LabItemTyp;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Assert;
import org.junit.Test;

public class LabItemTest
extends AbstractTest {
    @Test
    public void create() {
        ILabItem item = (ILabItem)this.coreModelService.create(ILabItem.class);
        Assert.assertNotNull((Object)item);
        Assert.assertTrue((boolean)(item instanceof ILabItem));
        item.setCode("testItem");
        item.setName("test item name");
        item.setReferenceFemale("<25");
        item.setReferenceMale("<30");
        item.setTyp(LabItemTyp.NUMERIC);
        this.coreModelService.save((Identifiable)item);
        Optional loadedItem = this.coreModelService.load(item.getId(), ILabItem.class);
        Assert.assertTrue((boolean)loadedItem.isPresent());
        Assert.assertFalse((item == loadedItem.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)item, loadedItem.get());
        Assert.assertEquals((Object)item.getCode(), (Object)((ILabItem)loadedItem.get()).getCode());
        Assert.assertEquals((Object)item.getReferenceFemale(), (Object)((ILabItem)loadedItem.get()).getReferenceFemale());
        Assert.assertEquals((Object)item.getReferenceMale(), (Object)((ILabItem)loadedItem.get()).getReferenceMale());
        Assert.assertEquals((Object)item.getTyp(), (Object)((ILabItem)loadedItem.get()).getTyp());
        this.coreModelService.remove((Identifiable)item);
    }

    @Test
    public void builder() {
        ILabItem labItem = new ILabItemBuilder(this.coreModelService, "TST", "Test", "5-10", "5-12", "nmol/l", LabItemTyp.NUMERIC, "T", 1).buildAndSave();
        Assert.assertEquals((Object)"TST", (Object)labItem.getCode());
        Assert.assertEquals((Object)"Test", (Object)labItem.getName());
        Assert.assertEquals((Object)"5-10", (Object)labItem.getReferenceMale());
        Assert.assertEquals((Object)"5-12", (Object)labItem.getReferenceFemale());
        Assert.assertEquals((Object)"nmol/l", (Object)labItem.getUnit());
        Assert.assertEquals((Object)LabItemTyp.NUMERIC, (Object)labItem.getTyp());
        Assert.assertEquals((Object)"T", (Object)labItem.getGroup());
        Assert.assertTrue((boolean)labItem.isVisible());
        Assert.assertFalse((boolean)labItem.isDeleted());
        this.coreModelService.remove((Identifiable)labItem);
    }

    @Test
    public void query() {
        ILabItem item1 = (ILabItem)this.coreModelService.create(ILabItem.class);
        item1.setCode("testItem1");
        item1.setName("test item 1");
        item1.setReferenceFemale("<25");
        item1.setReferenceMale("<30");
        item1.setTyp(LabItemTyp.NUMERIC);
        this.coreModelService.save((Identifiable)item1);
        ILabItem item2 = (ILabItem)this.coreModelService.create(ILabItem.class);
        item2.setCode("testItem2");
        item2.setName("test item 2");
        item2.setReferenceFemale("<25");
        item2.setReferenceMale("<30");
        item2.setTyp(LabItemTyp.TEXT);
        this.coreModelService.save((Identifiable)item2);
        IQuery query = this.coreModelService.getQuery(ILabItem.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_ITEM__CODE, IQuery.COMPARATOR.EQUALS, (Object)"testItem2");
        List existing = query.execute();
        Assert.assertNotNull((Object)existing);
        Assert.assertFalse((boolean)existing.isEmpty());
        Assert.assertEquals((long)1L, (long)existing.size());
        Assert.assertFalse((item2 == existing.get(0) ? 1 : 0) != 0);
        Assert.assertEquals((Object)item2, existing.get(0));
        Assert.assertEquals((Object)item2.getCode(), (Object)((ILabItem)existing.get(0)).getCode());
        Assert.assertEquals((Object)LabItemTyp.TEXT, (Object)((ILabItem)existing.get(0)).getTyp());
        this.coreModelService.remove((Identifiable)item1);
        this.coreModelService.remove((Identifiable)item2);
    }
}

