/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.preference;

import ch.elexis.core.mail.MailTextTemplate;
import ch.elexis.core.mail.ui.dialogs.TextTemplateDialog;
import ch.elexis.core.model.IImage;
import ch.elexis.core.model.ITextTemplate;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.text.TextTemplateComposite;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.LoggerFactory;

public class TextTemplates
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Composite parentComposite;
    private ComboViewer templatesViewer;
    private TextTemplateComposite templateComposite;
    private Button defaultBtn;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.parentComposite = new Composite(parent, 0);
        this.parentComposite.setLayout((Layout)new GridLayout(2, false));
        this.templatesViewer = new ComboViewer(this.parentComposite);
        this.templatesViewer.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.templatesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.templatesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ITextTemplate) {
                    return String.valueOf(((ITextTemplate)element).getName()) + (((ITextTemplate)element).getMandator() != null ? " (" + ((ITextTemplate)element).getMandator().getLabel() + ")" : "");
                }
                return super.getText(element);
            }
        });
        this.updateTemplatesCombo();
        this.templatesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getStructuredSelection() != null && event.getStructuredSelection().getFirstElement() instanceof ITextTemplate) {
                    TextTemplates.this.templateComposite.save();
                    ITextTemplate selectedTemplate = (ITextTemplate)event.getStructuredSelection().getFirstElement();
                    TextTemplates.this.templateComposite.setTemplate(selectedTemplate);
                    String defaultTemplateId = ConfigServiceHolder.get().get("mail/template/default", null);
                    if (defaultTemplateId != null && selectedTemplate.getId().equals(defaultTemplateId)) {
                        TextTemplates.this.defaultBtn.setSelection(true);
                    } else {
                        TextTemplates.this.defaultBtn.setSelection(false);
                    }
                } else {
                    TextTemplates.this.templateComposite.setTemplate(null);
                    TextTemplates.this.defaultBtn.setSelection(false);
                }
            }
        });
        ToolBar accountsTool = new ToolBar(this.parentComposite, 0);
        ToolBarManager accountsToolMgr = new ToolBarManager(accountsTool);
        accountsToolMgr.add((IAction)new AddTextTemplateAction());
        accountsToolMgr.add((IAction)new RemoveTextTemplateAction());
        accountsToolMgr.update(true);
        this.templateComposite = new TextTemplateComposite(this.parentComposite, 0);
        this.templateComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Composite buttonComposite = new Composite(this.parentComposite, 0);
        buttonComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        buttonComposite.setLayout((Layout)new RowLayout());
        final Button logoBtn = new Button(buttonComposite, 8);
        if (this.loadImage("elexismailpraxislogo").isPresent()) {
            logoBtn.setText("Praxis Logo \u00fcberschreiben");
        } else {
            logoBtn.setText("Praxis Logo setzen");
        }
        logoBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void widgetSelected(SelectionEvent e) {
                File file;
                FileDialog dialog = new FileDialog(TextTemplates.this.getShell());
                String filename = dialog.open();
                if (filename == null || !(file = new File(filename)).exists()) return;
                IImage image = TextTemplates.this.loadImage("elexismailpraxislogo").orElse(TextTemplates.this.createImage());
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try {
                        FileInputStream in = new FileInputStream(file);
                        try {
                            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                                IOUtils.copy((InputStream)in, (OutputStream)out);
                                out.flush();
                                image.setImage(out.toByteArray());
                                image.setTitle("elexismailpraxislogo." + FilenameUtils.getExtension((String)file.getName()));
                                CoreModelServiceHolder.get().save((Identifiable)image);
                                logoBtn.setText("Praxis Logo \u00fcberschreiben");
                            }
                            if (in == null) return;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (in == null) throw throwable;
                            in.close();
                            throw throwable;
                        }
                        in.close();
                        return;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        } else {
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e1) {
                    MessageDialog.openError((Shell)TextTemplates.this.getShell(), (String)"Fehler", (String)"Die Datei konnte nicht als Praxis Logo importiert werden.");
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error importing praxislogo", (Object)e);
                }
            }
        });
        this.defaultBtn = new Button(buttonComposite, 32);
        this.defaultBtn.setText("Als Standard Vorlage verwenden");
        this.defaultBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selectedTemplate = TextTemplates.this.templatesViewer.getStructuredSelection();
                if (selectedTemplate != null && selectedTemplate.getFirstElement() instanceof ITextTemplate) {
                    ConfigServiceHolder.get().set("mail/template/default", ((ITextTemplate)selectedTemplate.getFirstElement()).getId());
                }
            }
        });
        return this.parentComposite;
    }

    private IImage createImage() {
        IImage image = (IImage)CoreModelServiceHolder.get().create(IImage.class);
        image.setPrefix("ch.elexis.core.mail");
        return image;
    }

    private Optional<IImage> loadImage(String imageName) {
        IQuery query = CoreModelServiceHolder.get().getQuery(IImage.class);
        query.and("prefix", IQuery.COMPARATOR.EQUALS, (Object)"ch.elexis.core.mail");
        query.and("title", IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(imageName) + "%"));
        return query.executeSingleResult();
    }

    public boolean performOk() {
        this.templateComposite.save();
        return super.performOk();
    }

    private void updateTemplatesCombo() {
        this.templatesViewer.setInput((Object)MailTextTemplate.load());
        this.templatesViewer.refresh();
    }

    private class AddTextTemplateAction
    extends Action {
        private AddTextTemplateAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_NEW.getImageDescriptor();
        }

        public void run() {
            TextTemplateDialog dialog = new TextTemplateDialog(TextTemplates.this.getShell());
            if (dialog.open() == 0) {
                ITextTemplate template = (ITextTemplate)new MailTextTemplate.Builder().mandator(dialog.getMandator()).name(dialog.getName()).buildAndSave();
                TextTemplates.this.updateTemplatesCombo();
                TextTemplates.this.templatesViewer.setSelection((ISelection)new StructuredSelection((Object)template));
            }
        }
    }

    private class RemoveTextTemplateAction
    extends Action {
        private RemoveTextTemplateAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_DELETE.getImageDescriptor();
        }

        public void run() {
            IStructuredSelection selection = TextTemplates.this.templatesViewer.getStructuredSelection();
            if (selection != null && selection.getFirstElement() instanceof ITextTemplate) {
                TextTemplates.this.templatesViewer.setSelection((ISelection)new StructuredSelection());
                CoreModelServiceHolder.get().remove((Identifiable)((ITextTemplate)selection.getFirstElement()));
                TextTemplates.this.updateTemplatesCombo();
            }
        }
    }
}

