/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.liquibase;

import ch.elexis.core.jpa.entitymanager.ui.IDatabaseUpdateUi;
import ch.elexis.core.l10n.Messages;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.AbstractChangeExecListener;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.exception.ValidationFailedException;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiquibaseDBInitializer {
    private static Logger logger = LoggerFactory.getLogger(LiquibaseDBInitializer.class);
    private DataSource dataSource;
    private String changelogXmlUrl;
    private IDatabaseUpdateUi updateProgress;

    public LiquibaseDBInitializer(DataSource dataSource, IDatabaseUpdateUi updateProgress) {
        this.dataSource = dataSource;
        this.changelogXmlUrl = "/db/elexisdb_master_initial.xml";
        this.updateProgress = updateProgress;
    }

    public void init() {
        block23: {
            ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor(this.getClass().getClassLoader());
            Liquibase liquibase = null;
            Connection connection = null;
            try {
                try {
                    connection = this.dataSource.getConnection();
                    JdbcConnection database = new JdbcConnection(connection);
                    Database targetDb = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)database);
                    liquibase = new Liquibase(this.changelogXmlUrl, (ResourceAccessor)resourceAccessor, targetDb);
                    DatabaseChangeLogLock[] existinglocks = liquibase.listLocks();
                    if (existinglocks.length > 0) {
                        long timestamp = existinglocks[0].getLockGranted().getTime();
                        if ((System.currentTimeMillis() - timestamp) / 1000L > 14400L) {
                            logger.warn("Releasing lock older than 4h");
                            liquibase.forceReleaseLocks();
                        } else {
                            this.updateProgress.setMessage(String.valueOf(Messages.LiquibaseDBInitializer_Database_Locked) + existinglocks[0].getLockedBy() + Messages.LiquibaseDBInitializer_At + existinglocks[0].getLockGranted());
                        }
                    }
                    if (this.updateProgress != null) {
                        liquibase.setChangeExecListener((ChangeExecListener)new AbstractChangeExecListener(){

                            public void willRun(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, ChangeSet.RunStatus runStatus) {
                                LiquibaseDBInitializer.this.updateProgress.setMessage(String.valueOf(Messages.LiquibaseDBInitializer_Init_Execute) + changeSet.getDescription());
                            }
                        });
                    }
                    if (this.isFirstStart(connection)) {
                        logger.info("Initialize database [" + connection + "] with liquibase");
                        liquibase.update("");
                        break block23;
                    }
                    logger.info("Synchronize liquibase log of database [" + connection + "]");
                    try {
                        liquibase.changeLogSync("");
                    }
                    catch (ValidationFailedException e) {
                        logger.info("Validation failed clear checksums and retry");
                        liquibase.clearCheckSums();
                        liquibase.changeLogSync("");
                    }
                }
                catch (SQLException | LiquibaseException e) {
                    logger.warn("Exception on DB init.", e);
                    String exceptionClassName = e.getClass().getSimpleName().toLowerCase();
                    if ((exceptionClassName.contains("connection") || exceptionClassName.contains("communication")) && this.updateProgress != null) {
                        this.updateProgress.requestDatabaseConnectionConfiguration(e.getMessage());
                    }
                    try {
                        if (liquibase != null) {
                            liquibase.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (liquibase != null) {
                        liquibase.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private boolean isFirstStart(Connection connection) {
        return !LiquibaseDBInitializer.getDbTables(connection).contains("CONFIG");
    }

    private static List<String> getDbTables(Connection con) {
        ArrayList<String> ret = new ArrayList<String>();
        ResultSet result = null;
        try {
            try {
                DatabaseMetaData metaData = con.getMetaData();
                result = metaData.getTables(con.getCatalog(), null, "%", new String[]{"TABLE"});
                while (result.next()) {
                    String tableName = result.getString("TABLE_NAME");
                    ret.add(tableName.toUpperCase());
                }
            }
            catch (SQLException ex) {
                throw new IllegalStateException("An exception occured while trying toanalyse the database.", ex);
            }
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return ret;
    }
}

