/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities.listener;

import ch.elexis.core.jpa.entities.Config;
import ch.elexis.core.jpa.entities.Invoice;
import ch.elexis.core.jpa.entities.entitymanager.ElexisEntityManagerServiceHolder;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PrePersist;
import javax.persistence.TypedQuery;

public class InvoiceEntityListener {
    @PrePersist
    public void prePersist(Invoice invoice) {
        if (invoice.getNumber() == null) {
            invoice.setNumber(Integer.toString(this.findAndIncrementInvoiceNumber()));
        }
    }

    private int findAndIncrementInvoiceNumber() {
        int ret = 0;
        EntityManager em = (EntityManager)ElexisEntityManagerServiceHolder.getEntityManager().getEntityManager(false);
        try {
            em.getTransaction().begin();
            Config invoiceNr = (Config)em.find(Config.class, (Object)"RechnungsNr");
            if (invoiceNr == null) {
                Config invoiceNrConfig = new Config();
                invoiceNrConfig.setParam("RechnungsNr");
                invoiceNrConfig.setWert("1");
                em.persist((Object)invoiceNrConfig);
                ret = 1;
            } else {
                em.lock((Object)invoiceNr, LockModeType.PESSIMISTIC_WRITE);
                ret = Integer.parseInt(invoiceNr.getWert());
                ++ret;
                while (true) {
                    TypedQuery query = em.createNamedQuery("Invoice.number", Invoice.class);
                    query.setParameter("number", (Object)Integer.toString(ret));
                    List results = query.getResultList();
                    if (results.isEmpty()) break;
                    ++ret;
                }
                invoiceNr.setWert(Integer.toString(ret));
            }
            em.getTransaction().commit();
            int n = ret;
            return n;
        }
        finally {
            ElexisEntityManagerServiceHolder.getEntityManager().closeEntityManager((Object)em);
        }
    }
}

