/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithExtInfo;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.converter.IntegerStringConverter;
import ch.elexis.core.jpa.entities.converter.PrescriptionEntryTypeConverter;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.model.util.ElexisIdGenerator;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="patient_artikel_joint")
@EntityListeners(value={EntityWithIdListener.class})
@Cache(expiry=15000)
public class Prescription
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
EntityWithExtInfo,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    protected Long lastupdate;
    @Id
    @GeneratedValue(generator="system-uuid")
    @Column(unique=true, nullable=false, length=25)
    private String id;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted;
    @Lob
    protected byte[] extInfo;
    @Column(length=3)
    private String anzahl;
    @Column(length=255)
    private String artikel;
    @Column(length=255)
    private String bemerkung;
    @Column(length=24)
    private LocalDateTime dateFrom;
    @Column(length=24)
    private LocalDateTime dateUntil;
    @Column(length=255)
    private String dosis;
    @Column(length=2, name="prescType")
    @Convert(converter=PrescriptionEntryTypeConverter.class)
    private EntryType entryType;
    @OneToOne
    @JoinColumn(name="patientID")
    private Kontakt patient;
    @OneToOne
    @JoinColumn(name="prescriptor")
    private Kontakt prescriptor;
    @Column(length=25)
    private String rezeptID;
    @Column(length=25)
    private String artikelID;
    @Column(length=3)
    @Convert(converter=IntegerStringConverter.class)
    private int sortorder;
    static final long serialVersionUID = 5869790978239028L;

    public Prescription() {
        this.id = ElexisIdGenerator.generateId();
        this.deleted = false;
    }

    public String getAnzahl() {
        return this._persistence_get_anzahl();
    }

    public void setAnzahl(String anzahl) {
        this._persistence_set_anzahl(anzahl);
    }

    public String getArtikel() {
        return this._persistence_get_artikel();
    }

    public void setArtikel(String artikel) {
        this._persistence_set_artikel(artikel);
    }

    public String getArtikelID() {
        return this._persistence_get_artikelID();
    }

    public String getBemerkung() {
        return this._persistence_get_bemerkung();
    }

    public void setBemerkung(String bemerkung) {
        this._persistence_set_bemerkung(bemerkung);
    }

    public LocalDateTime getDateFrom() {
        return this._persistence_get_dateFrom();
    }

    public void setDateFrom(LocalDateTime dateFrom) {
        this._persistence_set_dateFrom(dateFrom);
    }

    public LocalDateTime getDateUntil() {
        return this._persistence_get_dateUntil();
    }

    public void setDateUntil(LocalDateTime dateUntil) {
        this._persistence_set_dateUntil(dateUntil);
    }

    public EntryType getEntryType() {
        return this._persistence_get_entryType();
    }

    public void setEntryType(EntryType entryType) {
        this._persistence_set_entryType(entryType);
    }

    public String getDosis() {
        return this._persistence_get_dosis();
    }

    public void setDosis(String dosis) {
        this._persistence_set_dosis(dosis);
    }

    public Kontakt getPatient() {
        return this._persistence_get_patient();
    }

    public void setPatient(Kontakt patient) {
        this._persistence_set_patient(patient);
    }

    public Kontakt getPrescriptor() {
        return this._persistence_get_prescriptor();
    }

    public void setPrescriptor(Kontakt patient) {
        this._persistence_set_prescriptor(patient);
    }

    public String getRezeptID() {
        return this._persistence_get_rezeptID();
    }

    public void setRezeptID(String rezeptID) {
        this._persistence_set_rezeptID(rezeptID);
    }

    public int getSortorder() {
        return this._persistence_get_sortorder();
    }

    public void setSortorder(int sortorder) {
        this._persistence_set_sortorder(sortorder);
    }

    @Override
    public byte[] getExtInfo() {
        return this._persistence_get_extInfo();
    }

    @Override
    public void setExtInfo(byte[] extInfo) {
        this._persistence_set_extInfo(extInfo);
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Prescription(persistenceObject);
    }

    public Prescription(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "artikelID") {
            return this.artikelID;
        }
        if (string == "entryType") {
            return this.entryType;
        }
        if (string == "prescriptor") {
            return this.prescriptor;
        }
        if (string == "dosis") {
            return this.dosis;
        }
        if (string == "dateUntil") {
            return this.dateUntil;
        }
        if (string == "dateFrom") {
            return this.dateFrom;
        }
        if (string == "extInfo") {
            return this.extInfo;
        }
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "rezeptID") {
            return this.rezeptID;
        }
        if (string == "artikel") {
            return this.artikel;
        }
        if (string == "anzahl") {
            return this.anzahl;
        }
        if (string == "patient") {
            return this.patient;
        }
        if (string == "bemerkung") {
            return this.bemerkung;
        }
        if (string == "sortorder") {
            return this.sortorder;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "id") {
            return this.id;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "artikelID") {
            this.artikelID = (String)object;
            return;
        }
        if (string == "entryType") {
            this.entryType = (EntryType)object;
            return;
        }
        if (string == "prescriptor") {
            this.prescriptor = (Kontakt)object;
            return;
        }
        if (string == "dosis") {
            this.dosis = (String)object;
            return;
        }
        if (string == "dateUntil") {
            this.dateUntil = (LocalDateTime)object;
            return;
        }
        if (string == "dateFrom") {
            this.dateFrom = (LocalDateTime)object;
            return;
        }
        if (string == "extInfo") {
            this.extInfo = (byte[])object;
            return;
        }
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "rezeptID") {
            this.rezeptID = (String)object;
            return;
        }
        if (string == "artikel") {
            this.artikel = (String)object;
            return;
        }
        if (string == "anzahl") {
            this.anzahl = (String)object;
            return;
        }
        if (string == "patient") {
            this.patient = (Kontakt)object;
            return;
        }
        if (string == "bemerkung") {
            this.bemerkung = (String)object;
            return;
        }
        if (string == "sortorder") {
            this.sortorder = (Integer)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_artikelID() {
        this._persistence_checkFetched("artikelID");
        return this.artikelID;
    }

    public void _persistence_set_artikelID(String string) {
        this._persistence_checkFetchedForSet("artikelID");
        this._persistence_propertyChange("artikelID", this.artikelID, string);
        this.artikelID = string;
    }

    public EntryType _persistence_get_entryType() {
        this._persistence_checkFetched("entryType");
        return this.entryType;
    }

    public void _persistence_set_entryType(EntryType entryType) {
        this._persistence_checkFetchedForSet("entryType");
        this._persistence_propertyChange("entryType", this.entryType, entryType);
        this.entryType = entryType;
    }

    public Kontakt _persistence_get_prescriptor() {
        this._persistence_checkFetched("prescriptor");
        return this.prescriptor;
    }

    public void _persistence_set_prescriptor(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("prescriptor");
        this._persistence_propertyChange("prescriptor", this.prescriptor, kontakt);
        this.prescriptor = kontakt;
    }

    public String _persistence_get_dosis() {
        this._persistence_checkFetched("dosis");
        return this.dosis;
    }

    public void _persistence_set_dosis(String string) {
        this._persistence_checkFetchedForSet("dosis");
        this._persistence_propertyChange("dosis", this.dosis, string);
        this.dosis = string;
    }

    public LocalDateTime _persistence_get_dateUntil() {
        this._persistence_checkFetched("dateUntil");
        return this.dateUntil;
    }

    public void _persistence_set_dateUntil(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("dateUntil");
        this._persistence_propertyChange("dateUntil", this.dateUntil, localDateTime);
        this.dateUntil = localDateTime;
    }

    public LocalDateTime _persistence_get_dateFrom() {
        this._persistence_checkFetched("dateFrom");
        return this.dateFrom;
    }

    public void _persistence_set_dateFrom(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("dateFrom");
        this._persistence_propertyChange("dateFrom", this.dateFrom, localDateTime);
        this.dateFrom = localDateTime;
    }

    public byte[] _persistence_get_extInfo() {
        this._persistence_checkFetched("extInfo");
        return this.extInfo;
    }

    public void _persistence_set_extInfo(byte[] byArray) {
        this._persistence_checkFetchedForSet("extInfo");
        this._persistence_propertyChange("extInfo", this.extInfo, byArray);
        this.extInfo = byArray;
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this._persistence_propertyChange("deleted", new Boolean(this.deleted), new Boolean(bl));
        this.deleted = bl;
    }

    public String _persistence_get_rezeptID() {
        this._persistence_checkFetched("rezeptID");
        return this.rezeptID;
    }

    public void _persistence_set_rezeptID(String string) {
        this._persistence_checkFetchedForSet("rezeptID");
        this._persistence_propertyChange("rezeptID", this.rezeptID, string);
        this.rezeptID = string;
    }

    public String _persistence_get_artikel() {
        this._persistence_checkFetched("artikel");
        return this.artikel;
    }

    public void _persistence_set_artikel(String string) {
        this._persistence_checkFetchedForSet("artikel");
        this._persistence_propertyChange("artikel", this.artikel, string);
        this.artikel = string;
    }

    public String _persistence_get_anzahl() {
        this._persistence_checkFetched("anzahl");
        return this.anzahl;
    }

    public void _persistence_set_anzahl(String string) {
        this._persistence_checkFetchedForSet("anzahl");
        this._persistence_propertyChange("anzahl", this.anzahl, string);
        this.anzahl = string;
    }

    public Kontakt _persistence_get_patient() {
        this._persistence_checkFetched("patient");
        return this.patient;
    }

    public void _persistence_set_patient(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("patient");
        this._persistence_propertyChange("patient", this.patient, kontakt);
        this.patient = kontakt;
    }

    public String _persistence_get_bemerkung() {
        this._persistence_checkFetched("bemerkung");
        return this.bemerkung;
    }

    public void _persistence_set_bemerkung(String string) {
        this._persistence_checkFetchedForSet("bemerkung");
        this._persistence_propertyChange("bemerkung", this.bemerkung, string);
        this.bemerkung = string;
    }

    public int _persistence_get_sortorder() {
        this._persistence_checkFetched("sortorder");
        return this.sortorder;
    }

    public void _persistence_set_sortorder(int n) {
        this._persistence_checkFetchedForSet("sortorder");
        this._persistence_propertyChange("sortorder", new Integer(this.sortorder), new Integer(n));
        this.sortorder = n;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this._persistence_propertyChange("lastupdate", this.lastupdate, l);
        this.lastupdate = l;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }
}

