/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.converter.DoubleStringConverter;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import ch.elexis.core.model.util.ElexisIdGenerator;
import ch.rgw.tools.StringTool;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="CH_MEDELEXIS_LABORTARIF2009")
@EntityListeners(value={EntityWithIdListener.class})
@NamedQuery(name="Labor2009Tarif.code", query="SELECT lt FROM Labor2009Tarif lt WHERE lt.deleted = false AND lt.code = :code")
public class Labor2009Tarif
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    protected Long lastupdate;
    @Id
    @GeneratedValue(generator="system-uuid")
    @Column(unique=true, nullable=false, length=25)
    private String id;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted;
    @Column(length=255)
    private String chapter;
    @Column(length=12)
    private String code;
    @Convert(converter=DoubleStringConverter.class)
    private double tp;
    @Column(length=255)
    private String name;
    @Lob
    private String limitatio;
    @Column(length=10)
    private String fachbereich;
    @Column(length=8)
    private LocalDate gueltigVon;
    @Column(length=8)
    private LocalDate gueltigBis;
    @Column(length=2)
    private String praxistyp;
    static final long serialVersionUID = 172387083802616987L;

    public Labor2009Tarif() {
        this.id = ElexisIdGenerator.generateId();
        this.deleted = false;
    }

    public String getChapter() {
        return this._persistence_get_chapter();
    }

    public void setChapter(String chapter) {
        this._persistence_set_chapter(chapter);
    }

    public String getCode() {
        return this._persistence_get_code();
    }

    public void setCode(String code) {
        this._persistence_set_code(code);
    }

    public double getTp() {
        return this._persistence_get_tp();
    }

    public void setTp(double tp) {
        this._persistence_set_tp(tp);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public String getLimitatio() {
        return this._persistence_get_limitatio();
    }

    public void setLimitatio(String limitatio) {
        this._persistence_set_limitatio(limitatio);
    }

    public String getFachbereich() {
        return this._persistence_get_fachbereich();
    }

    public void setFachbereich(String fachbereich) {
        this._persistence_set_fachbereich(fachbereich);
    }

    public LocalDate getGueltigVon() {
        return this._persistence_get_gueltigVon();
    }

    public void setGueltigVon(LocalDate gueltigVon) {
        this._persistence_set_gueltigVon(gueltigVon);
    }

    public LocalDate getGueltigBis() {
        return this._persistence_get_gueltigBis();
    }

    public void setGueltigBis(LocalDate gueltigBis) {
        this._persistence_set_gueltigBis(gueltigBis);
    }

    public String getPraxistyp() {
        return this._persistence_get_praxistyp();
    }

    public void setPraxistyp(String praxistyp) {
        this._persistence_set_praxistyp(praxistyp);
    }

    public String getCodeSystemName() {
        return "EAL 2009";
    }

    public String getText() {
        return StringTool.getFirstLine((String)this.getName(), (int)80);
    }

    public String getCodeSystemCode() {
        return "317";
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Labor2009Tarif(persistenceObject);
    }

    public Labor2009Tarif(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "chapter") {
            return this.chapter;
        }
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "code") {
            return this.code;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "limitatio") {
            return this.limitatio;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "gueltigBis") {
            return this.gueltigBis;
        }
        if (string == "tp") {
            return this.tp;
        }
        if (string == "gueltigVon") {
            return this.gueltigVon;
        }
        if (string == "fachbereich") {
            return this.fachbereich;
        }
        if (string == "praxistyp") {
            return this.praxistyp;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "chapter") {
            this.chapter = (String)object;
            return;
        }
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "code") {
            this.code = (String)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "limitatio") {
            this.limitatio = (String)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "gueltigBis") {
            this.gueltigBis = (LocalDate)object;
            return;
        }
        if (string == "tp") {
            this.tp = (Double)object;
            return;
        }
        if (string == "gueltigVon") {
            this.gueltigVon = (LocalDate)object;
            return;
        }
        if (string == "fachbereich") {
            this.fachbereich = (String)object;
            return;
        }
        if (string == "praxistyp") {
            this.praxistyp = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_chapter() {
        this._persistence_checkFetched("chapter");
        return this.chapter;
    }

    public void _persistence_set_chapter(String string) {
        this._persistence_checkFetchedForSet("chapter");
        this._persistence_propertyChange("chapter", this.chapter, string);
        this.chapter = string;
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this._persistence_propertyChange("deleted", new Boolean(this.deleted), new Boolean(bl));
        this.deleted = bl;
    }

    public String _persistence_get_code() {
        this._persistence_checkFetched("code");
        return this.code;
    }

    public void _persistence_set_code(String string) {
        this._persistence_checkFetchedForSet("code");
        this._persistence_propertyChange("code", this.code, string);
        this.code = string;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", this.name, string);
        this.name = string;
    }

    public String _persistence_get_limitatio() {
        this._persistence_checkFetched("limitatio");
        return this.limitatio;
    }

    public void _persistence_set_limitatio(String string) {
        this._persistence_checkFetchedForSet("limitatio");
        this._persistence_propertyChange("limitatio", this.limitatio, string);
        this.limitatio = string;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this._persistence_propertyChange("lastupdate", this.lastupdate, l);
        this.lastupdate = l;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public LocalDate _persistence_get_gueltigBis() {
        this._persistence_checkFetched("gueltigBis");
        return this.gueltigBis;
    }

    public void _persistence_set_gueltigBis(LocalDate localDate) {
        this._persistence_checkFetchedForSet("gueltigBis");
        this._persistence_propertyChange("gueltigBis", this.gueltigBis, localDate);
        this.gueltigBis = localDate;
    }

    public double _persistence_get_tp() {
        this._persistence_checkFetched("tp");
        return this.tp;
    }

    public void _persistence_set_tp(double d) {
        this._persistence_checkFetchedForSet("tp");
        this._persistence_propertyChange("tp", new Double(this.tp), new Double(d));
        this.tp = d;
    }

    public LocalDate _persistence_get_gueltigVon() {
        this._persistence_checkFetched("gueltigVon");
        return this.gueltigVon;
    }

    public void _persistence_set_gueltigVon(LocalDate localDate) {
        this._persistence_checkFetchedForSet("gueltigVon");
        this._persistence_propertyChange("gueltigVon", this.gueltigVon, localDate);
        this.gueltigVon = localDate;
    }

    public String _persistence_get_fachbereich() {
        this._persistence_checkFetched("fachbereich");
        return this.fachbereich;
    }

    public void _persistence_set_fachbereich(String string) {
        this._persistence_checkFetchedForSet("fachbereich");
        this._persistence_propertyChange("fachbereich", this.fachbereich, string);
        this.fachbereich = string;
    }

    public String _persistence_get_praxistyp() {
        this._persistence_checkFetched("praxistyp");
        return this.praxistyp;
    }

    public void _persistence_set_praxistyp(String string) {
        this._persistence_checkFetchedForSet("praxistyp");
        this._persistence_propertyChange("praxistyp", this.praxistyp, string);
        this.praxistyp = string;
    }
}

