/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.datasource.test;

import ch.elexis.core.common.DBConnection;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.Optional;

@Deprecated(forRemoval=true)
public class TestDatabaseConnection
extends DBConnection {
    private static final long serialVersionUID = 3263914071272054090L;
    public static final String TEST_DBFILE = "elexis.test.db.file";
    public static final String TEST_DBSERVER = "elexis.test.db.server";

    public static boolean isTestDbServer() {
        String testDbServer = System.getProperty(TEST_DBSERVER);
        return testDbServer != null && !testDbServer.isEmpty() && testDbServer.equalsIgnoreCase(Boolean.TRUE.toString());
    }

    public static Optional<String> getTestDbFile() {
        String testDbFile = System.getProperty(TEST_DBFILE);
        if (testDbFile != null && !testDbFile.isEmpty()) {
            return Optional.of(testDbFile);
        }
        return Optional.empty();
    }

    public TestDatabaseConnection() {
        this(TestDatabaseConnection.isTestDbServer());
    }

    public TestDatabaseConnection(boolean asServer) {
        this.rdbmsType = DBConnection.DBType.H2;
        this.databaseName = "elexisTest";
        this.username = "sa";
        this.password = "";
        Optional<String> fileLocation = TestDatabaseConnection.getTestDbFile();
        String testConnectionString = System.getProperty("elexis.test.db.connectionString");
        this.connectionString = testConnectionString != null ? testConnectionString : (asServer ? (fileLocation.isPresent() ? "jdbc:h2:" + fileLocation.get() + ";AUTO_SERVER=TRUE" : "jdbc:h2:~/elexisTest/elexisTest;AUTO_SERVER=TRUE") : "jdbc:h2:mem:elexisTest;DB_CLOSE_DELAY=-1");
        String trace = System.getProperty("elexis.test.dbtrace");
        if (trace != null && "true".equalsIgnoreCase(trace)) {
            this.connectionString = String.valueOf(this.connectionString) + ";TRACE_LEVEL_SYSTEM_OUT=2";
        }
        if (asServer && !fileLocation.isPresent()) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        Path dbdir = Paths.get(System.getenv("HOME"), "/elexisTest");
                        System.out.println("Cleaning up test database in [" + dbdir + "]");
                        Files.walk(dbdir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                    }
                    catch (IOException e) {
                        System.out.println("Error deleting database.");
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

