/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.model;

import ch.elexis.hl7.model.IValueType;
import ch.elexis.hl7.util.HL7Helper;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class ObservationMessage {
    String sendingApplication;
    String sendingFacility;
    Date dateTimeOfMessage = null;
    String messageControlID = "";
    String patientId;
    String alternatePatientId;
    String patientName;
    String patientLastName = "";
    String patientFirstName = "";
    String patientBirthdate = "";
    String patientSex = "";
    String patientNotesAndComments = "";
    String orderNumber;
    String orderNumberPlacer = "";
    String orderNumberFiller = "";
    Date dateTimeOfTransaction = null;
    List<IValueType> observations = new Vector<IValueType>();

    public ObservationMessage(String _sendingApplication, String _sendingFacility, String _dateTimeOfMessage, String _patientId, String _patientName, String _patientNotesAndComments, String _alternatePatientId, String _orderNumber) throws ParseException {
        this.sendingApplication = _sendingApplication;
        this.sendingFacility = _sendingFacility;
        this.patientId = _patientId;
        this.patientName = _patientName;
        this.patientNotesAndComments = _patientNotesAndComments;
        this.alternatePatientId = _alternatePatientId;
        this.orderNumber = _orderNumber;
        this.dateTimeOfMessage = HL7Helper.stringToDate(_dateTimeOfMessage);
    }

    public ObservationMessage(String _sendingApplication, String _sendingFacility, String _dateTimeOfMessage, String _messageControlID, String _dateTimeOfTransaction, String _patientId, String _patientLastName, String _patientFirstName, String _patientNotesAndComments, String _patientBirthDate, String _patientSex, String _alternatePatientId, String _orderNumberPlacer, String _orderNumberFiller) throws ParseException {
        this.sendingApplication = _sendingApplication;
        this.sendingFacility = _sendingFacility;
        this.dateTimeOfMessage = HL7Helper.stringToDate(_dateTimeOfMessage);
        this.messageControlID = _messageControlID;
        this.patientId = _patientId;
        this.patientLastName = _patientLastName;
        this.patientFirstName = _patientFirstName;
        this.patientNotesAndComments = _patientNotesAndComments;
        this.patientName = String.valueOf(_patientLastName) + " " + _patientFirstName;
        this.patientBirthdate = _patientBirthDate;
        this.patientSex = _patientSex;
        this.alternatePatientId = _alternatePatientId;
        this.orderNumberPlacer = _orderNumberPlacer;
        this.orderNumberFiller = _orderNumberFiller;
        this.dateTimeOfTransaction = HL7Helper.stringToDate(_dateTimeOfTransaction);
    }

    public void add(IValueType type) {
        this.observations.add(type);
    }

    public String getSendingApplication() {
        return this.sendingApplication;
    }

    public String getSendingFacility() {
        return this.sendingFacility;
    }

    public Date getDateTimeOfMessage() {
        return this.dateTimeOfMessage;
    }

    public String getMessageControlID() {
        return this.messageControlID;
    }

    public String getPatientId() {
        if (this.patientId == null || this.patientId.trim().length() == 0) {
            return this.alternatePatientId;
        }
        return this.patientId;
    }

    public String getAlternatePatientId() {
        return this.alternatePatientId;
    }

    public String getPatientName() {
        return this.patientName;
    }

    public String getPatientLastName() {
        return this.patientLastName;
    }

    public String getPatientFirstName() {
        return this.patientFirstName;
    }

    public String getPatientBirthdate() {
        return this.patientBirthdate;
    }

    public String getPatientSex() {
        return this.patientSex;
    }

    public String getPatientNotesAndComments() {
        return this.patientNotesAndComments;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public String getOrderNumberPlacer() {
        return this.orderNumberPlacer;
    }

    public String getOrderNumberFiller() {
        return this.orderNumberFiller;
    }

    public Date getDateTimeOfTransaction() {
        return this.dateTimeOfTransaction;
    }

    public List<IValueType> getObservations() {
        return this.observations;
    }
}

