/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.v231.datatype.XPN;
import ca.uhn.hl7v2.model.v231.datatype.XTN;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.PID;
import ca.uhn.hl7v2.model.v26.datatype.XAD;
import ca.uhn.hl7v2.model.v26.segment.ORC;
import ch.elexis.hl7.data.HL7Kontakt;
import ch.elexis.hl7.data.HL7Mandant;
import ch.elexis.hl7.data.HL7Patient;
import ch.elexis.hl7.util.HL7Helper;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public abstract class HL7Writer {
    List<String> errorList = new Vector<String>();
    List<String> warnList = new Vector<String>();
    protected String sendingApplication1 = "";
    protected String sendingApplication3 = "";
    protected String receivingApplication1 = "";
    protected String receivingApplication3 = "";
    protected String receivingFacility = "";

    static {
        System.setProperty("ca.uhn.hl7v2.validation.impl.WithdrawnDatatypeRule", "true");
    }

    public HL7Writer() {
    }

    public HL7Writer(String sendingApplication1, String sendingApplication3, String receivingApplication1, String receivingApplication3, String receivingFacility) {
        this();
        this.sendingApplication1 = sendingApplication1;
        this.sendingApplication3 = sendingApplication3;
        this.receivingApplication1 = receivingApplication1;
        this.receivingApplication3 = receivingApplication3;
        this.receivingFacility = receivingFacility;
    }

    public abstract String getVersion();

    public void clearMessages() {
        this.errorList = new Vector<String>();
        this.warnList = new Vector<String>();
    }

    public List<String> getErrorList() {
        return this.errorList;
    }

    public List<String> getWarningList() {
        return this.warnList;
    }

    protected void addError(String error) {
        this.errorList.add(error);
    }

    protected void addWarning(String warn) {
        this.errorList.add(warn);
    }

    protected void fillMSH(ca.uhn.hl7v2.model.v26.segment.MSH msh, String messageId, String event, HL7Mandant mandant, String uniqueMessageControlID, String uniqueProcessingID, HL7Patient patient) throws DataTypeException {
        msh.getMsh1_FieldSeparator().setValue("|");
        msh.getMsh2_EncodingCharacters().setValue("^~\\&");
        msh.getMsh3_SendingApplication().getHd1_NamespaceID().setValue(this.sendingApplication1);
        if (this.sendingApplication3 != null) {
            msh.getMsh3_SendingApplication().getHd2_UniversalID().setValue("");
            msh.getMsh3_SendingApplication().getHd3_UniversalIDType().setValue(this.sendingApplication3);
        }
        msh.getMsh4_SendingFacility().getHd1_NamespaceID().setValue(mandant.getLabel());
        msh.getMsh4_SendingFacility().getHd2_UniversalID().setValue(mandant.getEan());
        msh.getMsh4_SendingFacility().getHd3_UniversalIDType().setValue("L");
        msh.getMsh5_ReceivingApplication().getHd1_NamespaceID().setValue(this.receivingApplication1);
        if (this.receivingApplication3 != null) {
            msh.getMsh5_ReceivingApplication().getHd2_UniversalID().setValue("");
            msh.getMsh5_ReceivingApplication().getHd3_UniversalIDType().setValue(this.receivingApplication3);
        }
        msh.getMsh6_ReceivingFacility().getHd1_NamespaceID().setValue(this.receivingFacility);
        msh.getMsh7_DateTimeOfMessage().setValue(HL7Helper.dateToString(new Date()));
        msh.getMsh8_Security().setValue("");
        msh.getMsh9_MessageType().getMessageCode().setValue(messageId);
        msh.getMsh9_MessageType().getTriggerEvent().setValue(event);
        msh.getMsh9_MessageType().getMessageStructure().setValue("");
        if (uniqueMessageControlID != null) {
            msh.getMsh10_MessageControlID().setValue(uniqueMessageControlID);
        }
        if (uniqueProcessingID != null) {
            msh.getMsh11_ProcessingID().getPt1_ProcessingID().setValue(uniqueProcessingID);
        }
        msh.getMsh12_VersionID().getVid1_VersionID().setValue(this.getVersion());
    }

    protected void fillMSH(MSH msh, String messageId, String event, HL7Mandant mandant, String uniqueMessageControlID, String encoding, HL7Patient patient) throws DataTypeException {
        msh.getMsh1_FieldSeparator().setValue("|");
        msh.getMsh2_EncodingCharacters().setValue("^~\\&");
        msh.getMsh3_SendingApplication().getHd1_NamespaceID().setValue(this.sendingApplication1);
        if (this.sendingApplication3 != null) {
            msh.getMsh3_SendingApplication().getHd2_UniversalID().setValue("");
            msh.getMsh3_SendingApplication().getHd3_UniversalIDType().setValue(this.sendingApplication3);
        }
        msh.getMsh4_SendingFacility().getHd1_NamespaceID().setValue(mandant.getLabel());
        msh.getMsh4_SendingFacility().getHd2_UniversalID().setValue(mandant.getEan());
        msh.getMsh4_SendingFacility().getHd3_UniversalIDType().setValue("L");
        msh.getMsh5_ReceivingApplication().getHd1_NamespaceID().setValue(this.receivingApplication1);
        if (this.receivingApplication3 != null) {
            msh.getMsh5_ReceivingApplication().getHd2_UniversalID().setValue("");
            msh.getMsh5_ReceivingApplication().getHd3_UniversalIDType().setValue(this.receivingApplication3);
        }
        msh.getMsh6_ReceivingFacility().getHd1_NamespaceID().setValue(this.receivingFacility);
        msh.getMsh7_DateTimeOfMessage().getTs1_TimeOfAnEvent().setValue(HL7Helper.dateToString(new Date()));
        msh.getMsh8_Security().setValue("");
        msh.getMsh9_MessageType().getMessageType().setValue(messageId);
        msh.getMsh9_MessageType().getTriggerEvent().setValue(event);
        msh.getMsh9_MessageType().getMessageStructure().setValue("");
        if (uniqueMessageControlID != null) {
            msh.getMsh10_MessageControlID().setValue(uniqueMessageControlID);
        }
        msh.getMsh11_ProcessingID().getPt1_ProcessingID().setValue("P");
        msh.getMsh12_VersionID().getVid1_VersionID().setValue(this.getVersion());
        msh.getMsh18_CharacterSet(0).setValue(encoding);
    }

    protected void fillPID(ca.uhn.hl7v2.model.v26.segment.PID pid, HL7Patient patient) throws DataTypeException, HL7Exception {
        String sex = "";
        if (patient.isMale() != null) {
            sex = "M";
            if (!patient.isMale().booleanValue()) {
                sex = "F";
            }
        }
        pid.getPid1_SetIDPID().setValue("1");
        pid.getPid2_PatientID().getIDNumber().setValue(patient.getPatCode());
        pid.getPid3_PatientIdentifierList(0).getIDNumber().setValue(patient.getPatCode());
        pid.getPid4_AlternatePatientIDPID(0).getIDNumber().setValue(patient.getPatCode());
        this.addKontaktToXPN(pid.getPid5_PatientName(0), (HL7Kontakt)patient);
        pid.getPid16_MaritalStatus().getCwe1_Identifier().setValue("");
        pid.getPid7_DateTimeOfBirth().setValue(HL7Helper.dateToString(patient.getBirthdate()));
        pid.getPid8_AdministrativeSex().setValue(sex);
        pid.getPid9_PatientAlias(0).getXpn1_FamilyName().getFn1_Surname().setValue("");
        pid.getPid10_Race(0).getCwe1_Identifier().setValue("");
        this.addAddressToXAD(pid.getPid11_PatientAddress(0), (HL7Kontakt)patient);
        pid.getPid12_CountyCode().setValue("");
        this.addPhone1ToXTN(pid.getPid13_PhoneNumberHome(0), (HL7Kontakt)patient);
        this.addPhone2ToXTN(pid.getPid14_PhoneNumberBusiness(0), patient);
    }

    protected void fillPID(PID pid, HL7Patient patient) throws DataTypeException, HL7Exception {
        String sex = "";
        if (patient.isMale() != null) {
            sex = "M";
            if (!patient.isMale().booleanValue()) {
                sex = "F";
            }
        }
        pid.getPid1_SetIDPID().setValue("1");
        pid.getPid2_PatientID().getID().setValue(patient.getPatCode());
        pid.getPid3_PatientIdentifierList(0).getID().setValue(patient.getPatCode());
        pid.getPid4_AlternatePatientIDPID(0).getID().setValue(patient.getPatCode());
        this.addKontaktToXPN(pid.getPid5_PatientName(0), (HL7Kontakt)patient);
        pid.getPid16_MaritalStatus().getCe1_Identifier().setValue("");
        pid.getPid7_DateTimeOfBirth().getTs1_TimeOfAnEvent().setValue(HL7Helper.dateToString(patient.getBirthdate()));
        pid.getPid8_Sex().setValue(sex);
        pid.getPid9_PatientAlias(0).getXpn1_FamilyLastName().getFn1_FamilyName().setValue("");
        pid.getPid10_Race(0).getCe1_Identifier().setValue("");
        this.addAddressToXAD(pid.getPid11_PatientAddress(0), (HL7Kontakt)patient);
        pid.getPid12_CountyCode().setValue("");
        this.addPhone1ToXTN(pid.getPid13_PhoneNumberHome(0), (HL7Kontakt)patient);
    }

    protected void fillORC(ORC orc, String orderControl, Long orderNumber) throws DataTypeException {
        orc.getOrc1_OrderControl().setValue(orderControl);
        if (orderNumber != null) {
            orc.getOrc2_PlacerOrderNumber().getEi1_EntityIdentifier().setValue(orderNumber.toString());
        }
    }

    protected void addKontaktToXPN(ca.uhn.hl7v2.model.v26.datatype.XPN xpn, HL7Kontakt kontakt) throws DataTypeException {
        String name = "";
        String vorname = "";
        String title = "";
        if (kontakt != null) {
            name = kontakt.getName();
            vorname = kontakt.getFirstname();
            title = kontakt.getTitle();
        }
        xpn.getXpn1_FamilyName().getSurname().setValue(name);
        xpn.getXpn2_GivenName().setValue(vorname);
        xpn.getXpn3_SecondAndFurtherGivenNamesOrInitialsThereof().setValue("");
        xpn.getXpn4_SuffixEgJRorIII().setValue("");
        xpn.getXpn5_PrefixEgDR().setValue("");
        xpn.getXpn6_DegreeEgMD().setValue(title);
        xpn.getXpn7_NameTypeCode().setValue("");
        xpn.getXpn8_NameRepresentationCode().setValue("");
        xpn.getXpn9_NameContext().getCwe1_Identifier().setValue("");
    }

    protected void addKontaktToXPN(XPN xpn, HL7Kontakt kontakt) throws DataTypeException {
        String name = "";
        String vorname = "";
        String title = "";
        if (kontakt != null) {
            name = kontakt.getName();
            vorname = kontakt.getFirstname();
            title = kontakt.getTitle();
        }
        xpn.getXpn1_FamilyLastName().getFamilyName().setValue(name);
        xpn.getXpn2_GivenName().setValue(vorname);
        xpn.getXpn4_SuffixEgJRorIII().setValue("");
        xpn.getXpn5_PrefixEgDR().setValue("");
        xpn.getXpn6_DegreeEgMD().setValue(title);
        xpn.getXpn7_NameTypeCode().setValue("");
        xpn.getXpn8_NameRepresentationCode().setValue("");
    }

    protected void addAddressToXAD(XAD xad, HL7Kontakt kontakt) throws DataTypeException {
        String street = "";
        String other = "";
        String city = "";
        String zip = "";
        String country = "";
        if (kontakt != null) {
            street = kontakt.getAddress1();
            other = kontakt.getAddress2();
            city = kontakt.getCity();
            zip = kontakt.getZip();
            country = kontakt.getCountry();
        }
        xad.getXad1_StreetAddress().getSad1_StreetOrMailingAddress().setValue(street);
        xad.getXad2_OtherDesignation().setValue(other);
        xad.getXad3_City().setValue(city);
        xad.getXad4_StateOrProvince().setValue("");
        xad.getXad5_ZipOrPostalCode().setValue(zip);
        xad.getXad6_Country().setValue(country);
    }

    protected void addAddressToXAD(ca.uhn.hl7v2.model.v231.datatype.XAD xad, HL7Kontakt kontakt) throws DataTypeException {
        String street = "";
        String other = "";
        String city = "";
        String zip = "";
        String country = "";
        if (kontakt != null) {
            street = kontakt.getAddress1();
            other = kontakt.getAddress2();
            city = kontakt.getCity();
            zip = kontakt.getZip();
            country = kontakt.getCountry();
        }
        xad.getXad1_StreetAddress().setValue(street);
        xad.getXad2_OtherDesignation().setValue(other);
        xad.getXad3_City().setValue(city);
        xad.getXad4_StateOrProvince().setValue("");
        xad.getXad5_ZipOrPostalCode().setValue(zip);
        xad.getXad6_Country().setValue(country);
    }

    protected void addPhone1ToXTN(ca.uhn.hl7v2.model.v26.datatype.XTN xtn, HL7Kontakt kontakt) throws DataTypeException {
        String phone1 = "";
        String email = "";
        String fax = "";
        if (kontakt != null) {
            phone1 = kontakt.getPhone1();
            email = kontakt.getEmail();
            fax = kontakt.getFax();
        }
        if (phone1 != null && !phone1.isEmpty()) {
            xtn.getXtn2_TelecommunicationUseCode().setValue("PRN");
            xtn.getXtn3_TelecommunicationEquipmentType().setValue("PH");
            xtn.getXtn4_CommunicationAddress().setValue(phone1);
        } else if (email != null && !email.isEmpty()) {
            xtn.getXtn2_TelecommunicationUseCode().setValue("PRN");
            xtn.getXtn3_TelecommunicationEquipmentType().setValue("Internet");
            xtn.getXtn4_CommunicationAddress().setValue(email);
        }
        xtn.getXtn5_CountryCode().setValue("");
        xtn.getXtn6_AreaCityCode().setValue("");
        xtn.getXtn7_LocalNumber().setValue("");
        xtn.getXtn8_Extension().setValue("");
        xtn.getXtn9_AnyText().setValue("");
        xtn.getXtn10_ExtensionPrefix().setValue("");
        xtn.getXtn11_SpeedDialCode().setValue(fax);
    }

    protected void addPhone1ToXTN(XTN xtn, HL7Kontakt kontakt) throws DataTypeException {
        String phone1 = "";
        String email = "";
        String fax = "";
        if (kontakt != null) {
            phone1 = kontakt.getPhone1();
            email = kontakt.getEmail();
            fax = kontakt.getFax();
        }
        if (phone1 != null) {
            phone1 = phone1.replaceAll("[^\\d.]", "");
            xtn.getPhoneNumber().setValue(phone1);
        }
        if (email != null) {
            xtn.getEmailAddress().setValue(email);
        }
        xtn.getXtn2_TelecommunicationUseCode().setValue("");
        xtn.getXtn3_TelecommunicationEquipmentType().setValue("");
        xtn.getXtn5_CountryCode().setValue("");
        xtn.getXtn6_AreaCityCode().setValue("");
        xtn.getXtn8_Extension().setValue("");
        xtn.getXtn9_AnyText().setValue("");
    }

    protected void addPhone2ToXTN(ca.uhn.hl7v2.model.v26.datatype.XTN xtn, HL7Kontakt kontakt) throws DataTypeException {
        String phone2 = "";
        if (kontakt != null) {
            phone2 = kontakt.getPhone2();
        }
        if (phone2 != null && !phone2.isEmpty()) {
            xtn.getXtn2_TelecommunicationUseCode().setValue("WPN");
            xtn.getXtn3_TelecommunicationEquipmentType().setValue("PH");
            xtn.getXtn4_CommunicationAddress().setValue(phone2);
        }
    }
}

