/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.mapper;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.fhir.transformer.helper.IContactHelper;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IdentifiableDomainResourceAttributeMapper;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IXidService;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;

public class IOrganizationOrganizationAttributeMapper
implements IdentifiableDomainResourceAttributeMapper<IOrganization, Organization> {
    private IContactHelper contactHelper;
    private IXidService xidService;

    public IOrganizationOrganizationAttributeMapper(IXidService xidService) {
        this.xidService = xidService;
        this.contactHelper = new IContactHelper();
    }

    @Override
    public void elexisToFhir(IOrganization source, Organization target, SummaryEnum summaryEnum, Set<Include> includes) {
        target.setId((IIdType)new IdDt(Organization.class.getSimpleName(), source.getId()));
        this.mapMetaData((Identifiable)source, (DomainResource)target);
        if (SummaryEnum.DATA != summaryEnum) {
            this.mapNarrative((Identifiable)source, (DomainResource)target);
        }
        if (SummaryEnum.TEXT == summaryEnum || SummaryEnum.COUNT == summaryEnum) {
            return;
        }
        List<Identifier> identifiers = this.contactHelper.getIdentifiers((IContact)source, this.xidService);
        identifiers.add(this.getElexisObjectIdentifier((Identifiable)source));
        target.setIdentifier(identifiers);
        target.setName(this.contactHelper.getOrganizationName(source));
        this.mapContactPerson(source.getDescription3(), target.getContact());
        List<Address> addresses = this.contactHelper.getAddresses((IContact)source);
        for (Address address : addresses) {
            target.addAddress(address);
        }
        List<ContactPoint> contactPoints = this.contactHelper.getContactPoints((IContact)source);
        for (ContactPoint contactPoint : contactPoints) {
            target.addTelecom(contactPoint);
        }
        if (source.isLaboratory()) {
            target.addType().addCoding().setSystem("http://fhir.ch/ig/ch-epr-term/ValueSet/DocumentEntry.healthcareFacilityTypeCode").setCode("261904005").setDisplay("Laboratory");
        }
    }

    @Override
    public void fhirToElexis(Organization source, IOrganization target) {
        target.setDescription1(source.getName());
        this.contactHelper.mapIdentifiers(source.getIdentifier(), (IContact)target);
        this.contactHelper.mapAddress(source.getAddress(), (IContact)target);
        this.contactHelper.mapTelecom(source.getTelecom(), (IContact)target);
        this.mapContactPerson(source.getContact(), target);
        Coding hftcs = ModelUtil.getCodeableConceptBySystem((List<CodeableConcept>)source.getType(), "http://fhir.ch/ig/ch-epr-term/ValueSet/DocumentEntry.healthcareFacilityTypeCode").map(e -> e.getCodingFirstRep()).orElse(null);
        target.setLaboratory(StringUtils.equals((CharSequence)(hftcs != null ? hftcs.getCode() : null), (CharSequence)"261904005"));
    }

    private void mapContactPerson(String contactPersonName, List<Organization.OrganizationContactComponent> contact) {
        if (StringUtils.isNotBlank((CharSequence)contactPersonName)) {
            Organization.OrganizationContactComponent occ = new Organization.OrganizationContactComponent();
            occ.setName(new HumanName().setText(contactPersonName));
            contact.add(occ);
        }
    }

    private void mapContactPerson(List<Organization.OrganizationContactComponent> occs, IOrganization target) {
        if (!occs.isEmpty()) {
            target.setDescription3(occs.get(0).getName().getText());
        } else {
            target.setDescription3(null);
        }
    }
}

