/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.helper;

import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.fhir.transformer.helper.AbstractHelper;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.codesystems.PractitionerRole;

public class MandantHelper
extends AbstractHelper {
    public CodeableConcept getPractitionerRoleCode(String roleId) {
        CodeableConcept code = new CodeableConcept();
        if ("assistant".equals(roleId)) {
            code.addCoding(new Coding(PractitionerRole.NURSE.getSystem(), PractitionerRole.NURSE.toCode(), PractitionerRole.NURSE.toCode()));
        } else if ("doctor".equals(roleId)) {
            code.addCoding(new Coding(PractitionerRole.DOCTOR.getSystem(), PractitionerRole.DOCTOR.toCode(), PractitionerRole.DOCTOR.toCode()));
        } else if ("executive_doctor".equals(roleId)) {
            code.addCoding(new Coding(CodingSystem.ELEXIS_PRACTITIONER_ROLE.getSystem(), "mandant", "mandant"));
        } else {
            code.addCoding(new Coding(CodingSystem.ELEXIS_PRACTITIONER_ROLE.getSystem(), roleId, roleId));
        }
        return code;
    }
}

