/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.helper;

import ch.elexis.core.findings.util.fhir.MedicamentCoding;
import ch.elexis.core.model.IArticle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Ratio;
import org.hl7.fhir.r4.model.SimpleQuantity;

public class IMedicationHelper {
    public Coding getGtinCoding(String gtin) {
        if (StringUtils.isNumeric((CharSequence)gtin)) {
            return new Coding(MedicamentCoding.GTIN.getOid(), gtin, null);
        }
        return null;
    }

    public List<Coding> getAtcCodings(String atcCodes) {
        if (atcCodes != null && !atcCodes.isEmpty()) {
            String[] codes;
            ArrayList<Coding> ret = new ArrayList<Coding>();
            String[] stringArray = codes = atcCodes.split(";");
            int n = codes.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                ret.add(new Coding(MedicamentCoding.ATC.getOid(), string, null));
                ++n2;
            }
            return ret;
        }
        return Collections.emptyList();
    }

    public Coding getNameCoding(String name) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            return new Coding(MedicamentCoding.NAME.getUrl(), name, null);
        }
        return null;
    }

    public Coding getTypeCoding(IArticle localObject) {
        return new Coding(MedicamentCoding.TYPE.getUrl(), localObject.getTyp().getCodeSystemName(), null);
    }

    public Ratio determineAmount(IArticle localObject) {
        SimpleQuantity quantity = new SimpleQuantity();
        quantity.setUnit(localObject.getPackageUnit());
        try {
            quantity.setValue((long)localObject.getPackageSize());
        }
        catch (NumberFormatException e) {
            quantity.setUnit(String.valueOf(localObject.getPackageSize()) + ", " + localObject.getPackageUnit());
        }
        Ratio r = new Ratio();
        r.setDenominator((Quantity)quantity);
        r.setNumerator((Quantity)quantity);
        return r;
    }
}

