/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.helper;

import ch.elexis.core.fhir.CodeSystem;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.fhir.MedicamentCoding;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;

public class CodeSystemUtil {
    private static HashMap<String, String> systemIdMap = new HashMap<String, String>(){
        {
            this.put(CodingSystem.ELEXIS_COVERAGE_TYPE.getSystem(), "coveragetype");
            this.put(CodingSystem.ELEXIS_DIAGNOSE_TESSINERCODE.getSystem(), "tessinercode");
        }
    };

    private static boolean isSystemString(String string) {
        return string.startsWith("http://") || string.startsWith("www.elexis.info/");
    }

    public static Optional<String> getIdForString(String string) {
        if (CodeSystemUtil.isSystemString(string)) {
            return Optional.ofNullable(systemIdMap.get(string));
        }
        return Optional.of(string);
    }

    public static Optional<String> getSystemForId(String idString) {
        Set<String> keys = systemIdMap.keySet();
        for (String key : keys) {
            if (!systemIdMap.get(key).equals(idString)) continue;
            return Optional.of(key);
        }
        return Optional.empty();
    }

    public static Coding getGtinCoding(String gtin) {
        if (StringUtils.isNumeric((CharSequence)gtin)) {
            return new Coding(MedicamentCoding.GTIN.getUrl(), gtin, null);
        }
        return null;
    }

    public static Coding getCodeElementCoding(ICodeElementService codeElementService, ICodeElement codeElement) {
        Optional contribution = codeElementService.getContribution(null, codeElement.getCodeSystemName());
        String typName = ((ICodeElementServiceContribution)contribution.get()).getTyp().name().toLowerCase();
        String theSystem = String.valueOf(CodeSystem.CODEELEMENT.getUrl()) + "/" + typName + "/" + codeElement.getCodeSystemName().toLowerCase();
        Coding coding = new Coding(theSystem, "", codeElement.getText());
        coding.setCode(codeElement.getCode());
        return coding;
    }

    public static Optional<ICodeElement> loadCodeElementEntryInCodeableConcept(ICodeElementService codeElementService, CodeableConcept codeableConcept) {
        List codings = codeableConcept.getCoding();
        for (Coding coding : codings) {
            if (!StringUtils.startsWith((CharSequence)coding.getSystem(), (CharSequence)CodeSystem.CODEELEMENT.getUrl())) continue;
            String codeElementTypAndcodeSystemName = StringUtils.substring((String)coding.getSystem(), (int)(CodeSystem.CODEELEMENT.getUrl().length() + 1));
            String[] codes = codeElementTypAndcodeSystemName.split("/");
            return codeElementService.loadFromString(codes[1], coding.getCode(), null);
        }
        return Optional.empty();
    }
}

