/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.IdentifierSystem;
import ch.elexis.core.model.Identifiable;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.r4.model.Identifier;

public interface IFhirTransformer<F, L> {
    public static final String TRANSFORMERID = "transformer.id";

    public Optional<F> getFhirObject(L var1, SummaryEnum var2, Set<Include> var3);

    default public Optional<F> getFhirObject(L localObject) {
        return this.getFhirObject(localObject, SummaryEnum.FALSE, Collections.emptySet());
    }

    public Optional<L> getLocalObject(F var1);

    public Optional<L> updateLocalObject(F var1, L var2);

    public Optional<L> createLocalObject(F var1);

    public boolean matchesTypes(Class<?> var1, Class<?> var2);

    default public Identifier getElexisObjectIdentifier(Identifiable dbObject) {
        Identifier identifier = new Identifier();
        identifier.setSystem(IdentifierSystem.ELEXIS_OBJID.getSystem());
        identifier.setValue(dbObject.getId());
        return identifier;
    }
}

