/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.commands;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.IObservationLink;
import ch.elexis.core.findings.util.FindingsServiceHolder;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.commands.IFindingCommand;
import ch.elexis.core.findings.util.commands.ILockingProvider;
import ch.elexis.core.findings.util.commands.UpdateFindingTextCommand;
import java.util.ArrayList;
import java.util.List;

public class FindingDeleteCommand
implements IFindingCommand {
    private IFinding iFinding;
    private ILockingProvider locking;

    public FindingDeleteCommand(IFinding iFinding, ILockingProvider locking) {
        this.iFinding = iFinding;
        this.locking = locking;
    }

    @Override
    public void execute() throws ElexisException {
        if (this.iFinding instanceof IObservation) {
            IObservation iObservation = (IObservation)this.iFinding;
            IObservation rootObservation = ModelUtil.getRootObservationRecursive(iObservation);
            List<IObservation> observationChildrens = ModelUtil.getObservationChildren(iObservation, new ArrayList<IObservation>(), 100);
            ArrayList<IObservation> lockedChildrens = new ArrayList<IObservation>();
            for (IObservation iObservationChild : observationChildrens) {
                if (!this.locking.acquireLock(iObservationChild).isOk()) {
                    throw new ElexisException("Delete not possible, lock acquire failed");
                }
                lockedChildrens.add(iObservationChild);
            }
            for (IObservation child : lockedChildrens) {
                List sources = child.getSourceObservations(IObservationLink.ObservationLinkType.REF);
                for (IObservation source : sources) {
                    child.removeSourceObservation(source, IObservationLink.ObservationLinkType.REF);
                    source.removeTargetObservation(child, IObservationLink.ObservationLinkType.REF);
                }
                FindingsServiceHolder.getiFindingsService().deleteFinding((IFinding)child);
                this.locking.releaseLock(child);
            }
            List sources = iObservation.getSourceObservations(IObservationLink.ObservationLinkType.REF);
            for (IObservation source : sources) {
                iObservation.removeSourceObservation(source, IObservationLink.ObservationLinkType.REF);
                source.removeTargetObservation(iObservation, IObservationLink.ObservationLinkType.REF);
            }
            FindingsServiceHolder.getiFindingsService().deleteFinding((IFinding)iObservation);
            if (rootObservation != iObservation) {
                new UpdateFindingTextCommand((IFinding)rootObservation).execute();
            }
        }
    }
}

