/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.model;

import ca.uhn.fhir.model.primitive.IdDt;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IDocumentReference;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.fhir.model.AbstractFindingModelAdapter;
import ch.elexis.core.findings.fhir.model.service.DocumentStoreHolder;
import ch.elexis.core.findings.util.fhir.accessor.DocumentReferenceAccessor;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IXid;
import java.time.LocalDateTime;
import java.util.Optional;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Reference;
import org.slf4j.LoggerFactory;

public class DocumentReference
extends AbstractFindingModelAdapter<ch.elexis.core.jpa.entities.DocumentReference>
implements IDocumentReference {
    private DocumentReferenceAccessor accessor = new DocumentReferenceAccessor();

    public DocumentReference(ch.elexis.core.jpa.entities.DocumentReference entity) {
        super(entity);
    }

    public String getPatientId() {
        return ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).getPatientId();
    }

    public void setPatientId(String patientId) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            org.hl7.fhir.r4.model.DocumentReference fhirDocumentReference = (org.hl7.fhir.r4.model.DocumentReference)resource.get();
            fhirDocumentReference.setSubject(new Reference((IIdType)new IdDt("Patient", patientId)));
            this.saveResource(resource.get());
        }
        ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).setPatientId(patientId);
    }

    public IFinding.RawContentFormat getRawContentFormat() {
        return IFinding.RawContentFormat.FHIR_JSON;
    }

    public String getRawContent() {
        return ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).getContent();
    }

    public void setRawContent(String content) {
        ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).setContent(content);
    }

    public IDocument getDocument() {
        return DocumentStoreHolder.getDocument(((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).getDocumentStoreId(), ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).getDocumentId()).orElse(null);
    }

    public void setDocument(IDocument document) {
        ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).setDocumentStoreId(document.getStoreId());
        ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).setDocumentId(document.getId());
    }

    public ICoding getDocumentClass() {
        return this.loadResource().map(i -> this.accessor.getDocumentClass((DomainResource)i)).get().stream().findFirst().orElse(null);
    }

    public void setDocumentClass(ICoding coding) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setDocumentClass((DomainResource)resource.get(), coding);
            this.saveResource(resource.get());
        }
    }

    public String getCategory() {
        return this.loadResource().map(i -> this.accessor.getCategory((DomainResource)i).orElse(null)).orElse(null);
    }

    public void setCategory(String value) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setCategory((DomainResource)resource.get(), value);
            this.saveResource(resource.get());
        }
    }

    public ICoding getPracticeSetting() {
        return this.loadResource().map(i -> this.accessor.getPracticeSetting((DomainResource)i)).get().stream().findFirst().orElse(null);
    }

    public void setPracticeSetting(ICoding coding) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setPracticeSetting((DomainResource)resource.get(), coding);
            this.saveResource(resource.get());
        }
    }

    public ICoding getFacilityType() {
        return this.loadResource().map(i -> this.accessor.getFacilityType((DomainResource)i)).get().stream().findFirst().orElse(null);
    }

    public void setFacilityType(ICoding coding) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setFacilityType((DomainResource)resource.get(), coding);
            this.saveResource(resource.get());
        }
    }

    public Optional<LocalDateTime> getDate() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            org.hl7.fhir.r4.model.DocumentReference fhirDocument = (org.hl7.fhir.r4.model.DocumentReference)resource.get();
            try {
                if (fhirDocument.hasDate()) {
                    return Optional.of(this.getLocalDateTime(fhirDocument.getDate()));
                }
            }
            catch (FHIRException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Could not access date.", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public void setDate(LocalDateTime time) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            org.hl7.fhir.r4.model.DocumentReference fhirProcedureRequest = (org.hl7.fhir.r4.model.DocumentReference)resource.get();
            fhirProcedureRequest.setDate(this.getDate(time));
            this.saveResource(resource.get());
        }
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return false;
    }

    public IXid getXid(String domain) {
        return null;
    }

    public String getAuthorId() {
        return ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).getAuthorId();
    }

    public void setAuthorId(String authorId) {
        ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).setAuthorId(authorId);
    }

    public String getKeywords() {
        return ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).getKeywords();
    }

    public void setKeywords(String keywords) {
        ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).setKeywords(keywords);
    }
}

