/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data.dto;

import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IDiagnosisReference;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Verrechnet;
import ch.elexis.data.dto.DiagnosesDTO;
import ch.elexis.data.dto.LeistungDTO;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.List;

public class KonsultationDTO {
    private final String id;
    private List<LeistungDTO> leistungDTOs = new ArrayList<LeistungDTO>();
    private List<DiagnosesDTO> diagnosesDTOs = new ArrayList<DiagnosesDTO>();
    private String date;
    private String srcDate;
    private Mandant mandant;
    private List<ElexisException> errors = new ArrayList<ElexisException>();

    public KonsultationDTO(Konsultation konsultation) {
        this.errors.clear();
        this.id = konsultation.getId();
        this.date = konsultation.getDatum();
        this.srcDate = new String(konsultation.getDatum());
        this.mandant = konsultation.getMandant();
        for (Verrechnet verrechnet : konsultation.getLeistungen()) {
            try {
                this.leistungDTOs.add(new LeistungDTO(verrechnet));
            }
            catch (ElexisException e) {
                this.errors.add(e);
            }
        }
        for (IDiagnosisReference iDiagnose : NoPoUtil.loadAsIdentifiable(konsultation, IEncounter.class).get().getDiagnoses()) {
            this.diagnosesDTOs.add(new DiagnosesDTO((IDiagnosis)iDiagnose));
        }
    }

    public IEncounter getTransientCopyWithoutBillable(IBillable iVerrechenbar) {
        IEncounter copy = (IEncounter)CoreModelServiceHolder.get().create(IEncounter.class);
        copy.setDate(new TimeTool(this.date).toLocalDate());
        copy.setMandator(NoPoUtil.loadAsIdentifiable(this.mandant, IMandator.class).get());
        copy.setCoverage(((IEncounter)CoreModelServiceHolder.get().load(this.id, IEncounter.class).get()).getCoverage());
        for (LeistungDTO dto : this.leistungDTOs) {
            if (iVerrechenbar != null && iVerrechenbar.equals(dto.getIVerrechenbar())) continue;
            IBilled billedCopy = (IBilled)CoreModelServiceHolder.get().create(IBilled.class);
            billedCopy.setBiller((IContact)copy.getMandator());
            billedCopy.setAmount(dto.getCount());
            billedCopy.setPoints(dto.getTp());
            billedCopy.setFactor(dto.getTpw());
            billedCopy.setBillable(dto.getIVerrechenbar());
            billedCopy.setEncounter(copy);
            CoreModelServiceHolder.get().addToEntityList("getBilled", (Identifiable)billedCopy, (Identifiable)copy);
        }
        return copy;
    }

    public List<ElexisException> getErrors() {
        return this.errors;
    }

    public void setLeistungDTOs(List<LeistungDTO> leistungDTOs) {
        this.leistungDTOs = leistungDTOs;
    }

    public List<LeistungDTO> getLeistungDTOs() {
        return this.leistungDTOs;
    }

    public void setDiagnosesDTOs(List<DiagnosesDTO> diagnosesDTOs) {
        this.diagnosesDTOs = diagnosesDTOs;
    }

    public List<DiagnosesDTO> getDiagnosesDTOs() {
        return this.diagnosesDTOs;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getDate() {
        return this.date;
    }

    public String getSrcDate() {
        return this.srcDate;
    }

    public String getId() {
        return this.id;
    }

    public void setMandant(Mandant mandant) {
        this.mandant = mandant;
    }

    public Mandant getMandant() {
        return this.mandant;
    }
}

