/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.interfaces.ITransferable;
import ch.elexis.core.model.util.ElexisIdGenerator;
import ch.elexis.core.types.AddressType;
import ch.elexis.core.types.LocalizeUtil;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.dto.ZusatzAdresseDTO;
import ch.rgw.tools.StringTool;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.emf.common.util.Enumerator;

public class ZusatzAdresse
extends PersistentObject
implements ITransferable<ZusatzAdresseDTO> {
    protected static final String KONTAKT_ID = "Kontakt_Id";
    private static final String COUNTRY = "Land";
    private static final String PLACE = "Ort";
    private static final String ZIP = "Plz";
    public static final String STREET1 = "Strasse1";
    private static final String STREET2 = "Strasse2";
    public static final String TYPE = "Typ";
    public static final String POSTAL_ADDRESS = "Anschrift";
    public static final String TABLENAME = "ZusatzAdresse";
    private static final String[] FIELDS = new String[]{"Kontakt_Id", "Strasse1", "Strasse2", "Land", "Ort", "Plz", "Typ", "Anschrift"};

    static {
        ZusatzAdresse.addMapping(TABLENAME, KONTAKT_ID, STREET1, STREET2, ZIP, PLACE, COUNTRY, TYPE, POSTAL_ADDRESS);
    }

    protected ZusatzAdresse() {
    }

    protected ZusatzAdresse(String id) {
        super(id);
    }

    public ZusatzAdresse(Kontakt kontakt) {
        this.create(null, new String[]{KONTAKT_ID}, new String[]{kontakt.getId()});
    }

    public static ZusatzAdresse load(String id) {
        return new ZusatzAdresse(id);
    }

    public String getEtikette(boolean withName, boolean multiline) {
        return this.getEtikette(withName, multiline, this.get(KONTAKT_ID), this.get(STREET1), this.get(COUNTRY), this.get(ZIP), this.get(PLACE));
    }

    public String getEtikette(boolean withName, boolean multiline, String kontaktId, String street1, String country, String zip, String place) {
        String sep = "\n";
        if (!multiline) {
            sep = ", ";
        }
        StringBuilder ret = new StringBuilder(100);
        if (withName) {
            ret.append(Kontakt.load(kontaktId).getLabel(false)).append(sep);
        }
        if (street1 != null) {
            ret.append(street1).append(sep);
        }
        if (!StringTool.isNothing((Object)country)) {
            ret.append(country).append(" - ");
        }
        if (zip != null && place != null) {
            ret.append(zip).append(" ").append(place);
        }
        if (multiline) {
            ret.append("\n");
        }
        return ret.toString();
    }

    @Override
    public String getLabel() {
        String etikette = this.getEtikette(false, false);
        if (this.get(TYPE) != null) {
            return String.valueOf(LocalizeUtil.getLocaleText((Enumerator)AddressType.get((int)NumberUtils.toInt((String)this.get(TYPE))))) + ": " + etikette;
        }
        return etikette;
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    public ZusatzAdresseDTO getDTO() {
        if (this.getId() == null) {
            return new ZusatzAdresseDTO();
        }
        String[] values = new String[FIELDS.length];
        this.get(FIELDS, values);
        ZusatzAdresseDTO zusatzAddresseData = new ZusatzAdresseDTO();
        zusatzAddresseData.setId(this.getId());
        zusatzAddresseData.setKontaktId(values[0]);
        zusatzAddresseData.setStreet1(values[1]);
        zusatzAddresseData.setStreet2(values[2]);
        zusatzAddresseData.setCountry(values[3]);
        zusatzAddresseData.setPlace(values[4]);
        zusatzAddresseData.setZip(values[5]);
        zusatzAddresseData.setAddressType(AddressType.get((int)NumberUtils.toInt((String)values[6])));
        zusatzAddresseData.setPostalAddress(values[7]);
        return zusatzAddresseData;
    }

    public void persistDTO(ZusatzAdresseDTO zusatzAdresseDTO) throws ElexisException {
        if (zusatzAdresseDTO.getKontaktId() == null) {
            throw new ElexisException(ZusatzAdresse.class, "Kontakt not definied", 5, true);
        }
        if (this.getId() == null) {
            this.create(ElexisIdGenerator.generateId(), new String[]{KONTAKT_ID}, new String[]{zusatzAdresseDTO.getKontaktId()});
        }
        this.set(FIELDS, zusatzAdresseDTO.getKontaktId(), zusatzAdresseDTO.getStreet1(), zusatzAdresseDTO.getStreet2(), zusatzAdresseDTO.getCountry(), zusatzAdresseDTO.getPlace(), zusatzAdresseDTO.getZip(), String.valueOf(zusatzAdresseDTO.getAddressType().getValue()), zusatzAdresseDTO.getPostalAddress());
    }
}

