/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.IUser;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.net.NetTool;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class Trace {
    public static final String TABLENAME = "traces";
    private static ExecutorService executor = Executors.newSingleThreadExecutor();

    public static void addTraceEntry(String username, String workstation, String action) {
        executor.execute(() -> {
            IUser user;
            String _username = username;
            if (StringUtils.isEmpty((CharSequence)username) && (user = (IUser)ContextServiceHolder.get().getActiveUser().orElse(null)) != null) {
                _username = user.getId();
            }
            _username = StringUtils.isEmpty((CharSequence)_username) ? "unknown" : StringUtils.abbreviate((String)_username, (int)30);
            String _workstation = workstation;
            if (StringUtils.isEmpty((CharSequence)workstation)) {
                _workstation = NetTool.hostname;
            }
            _workstation = StringUtils.isEmpty((CharSequence)_workstation) ? "unknown" : StringUtils.abbreviate((String)_workstation, (int)40);
            String _action = StringUtils.isEmpty((CharSequence)action) ? "" : action;
            JdbcLink connection = PersistentObject.getConnection();
            String insertStatement = "INSERT INTO traces VALUES(?, ?, ?, ?)";
            if (connection != null) {
                PreparedStatement statement = connection.getPreparedStatement(insertStatement);
                try {
                    try {
                        statement.setLong(1, System.currentTimeMillis());
                        statement.setString(2, _workstation);
                        statement.setString(3, _username);
                        statement.setString(4, _action);
                        statement.execute();
                    }
                    catch (SQLException e) {
                        LoggerFactory.getLogger(Trace.class).error("Catched this - FIX IT", (Throwable)e);
                        connection.releasePreparedStatement(statement);
                    }
                }
                finally {
                    connection.releasePreparedStatement(statement);
                }
            } else {
                LoggerFactory.getLogger(Trace.class).warn("No DB connection for trace [station{} user{} action{}]", new Object[]{_workstation, _username, _action});
            }
        });
    }

    public static void addTraceEntry(String action) {
        Trace.addTraceEntry(null, null, action);
    }
}

