/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.data.Kontakt;
import ch.rgw.tools.JdbcLink;

public class Organisation
extends Kontakt {
    private static final String FLD_NAME = "Name";
    private static final String FLD_ZUSATZ1 = "Zusatz1";
    private static final String FLD_ZUSATZ2 = "Zusatz2";
    private static final String FLD_ZUSATZ3 = "Zusatz3";
    private static final String FLD_CONTACT_PERSON = "Ansprechperson";
    private static final String FLD_TEL_DIRECT = "Tel. direkt";
    public static final String FLD_XML_NAME = "XML Versicherer Name";
    public static final String FLD_LAW_CODE = "Versicherungsart";
    public static final String FLD_MEDIPORT_SUPPORT = "Mediport Teilnehmer";
    public static final String[] DEFAULT_SORT = new String[]{"Name", "Zusatz1"};

    static {
        Organisation.addMapping("KONTAKT", "Name=Bezeichnung1", "Zusatz1=Bezeichnung2", "Zusatz2=ExtInfo", "Ansprechperson=Bezeichnung3", "Zusatz3=TITEL", "Tel. direkt=NatelNr", "XML Versicherer Name=Allergien", "Versicherungsart=TitelSuffix", "Mediport Teilnehmer=Gruppe", "istOrganisation");
    }

    @Override
    public boolean isValid() {
        return super.isValid();
    }

    @Override
    protected String getTableName() {
        return "KONTAKT";
    }

    Organisation() {
    }

    protected Organisation(String id) {
        super(id);
    }

    public static Organisation load(String id) {
        return new Organisation(id);
    }

    public Organisation(String Name, String Zusatz1) {
        this.create(null);
        this.set(new String[]{FLD_NAME, FLD_ZUSATZ1}, Name, Zusatz1);
    }

    @Override
    protected String getConstraint() {
        return "istOrganisation" + "=" + JdbcLink.wrap((String)"1");
    }

    @Override
    protected void setConstraint() {
        this.set("istOrganisation", "1");
    }

    public String getXMLName() {
        return this.get(FLD_XML_NAME);
    }

    public String getLawCode() {
        return Organisation.checkNull(this.get(FLD_LAW_CODE));
    }

    public void setSupportsMediport(boolean mediportSupport) {
        if (mediportSupport) {
            this.set(FLD_MEDIPORT_SUPPORT, "1");
        } else {
            this.set(FLD_MEDIPORT_SUPPORT, "0");
        }
    }

    public boolean supportsMediport() {
        int mediportParticipant = Organisation.checkZero(this.get(FLD_MEDIPORT_SUPPORT));
        return mediportParticipant != 0;
    }

    public String getInsuranceEAN() {
        return Organisation.checkNull(this.getXid("www.xid.ch/id/ean"));
    }

    public void setInsurerEAN(String ean) {
        this.addXid("www.xid.ch/id/ean", ean, true);
    }

    public String getRecepientEAN() {
        return Organisation.checkNull(this.getXid("www.xid.ch/id/recipient_ean"));
    }

    public void setRecepientEAN(String ean) {
        this.addXid("www.xid.ch/id/recipient_ean", ean, true);
    }
}

