/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.data.Anwender;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;

public class BBSEntry
extends PersistentObject {
    static {
        BBSEntry.addMapping("BBS", "reference", "Thema=topic", "datum=S:D:date", "time", "authorID", "text=message");
    }

    public BBSEntry(String topic, Anwender author, BBSEntry ref, String text) {
        this.create(null);
        String refid = ref == null ? "NIL" : ref.getId();
        TimeTool tt = new TimeTool();
        this.set(new String[]{"reference", "Thema", "authorID", "datum", "time", "text"}, refid, topic, author.getId(), tt.toString(4), tt.toString(8), text);
    }

    public Anwender getAuthor() {
        return Anwender.load(this.get("authorID"));
    }

    public BBSEntry getReference() {
        return BBSEntry.load(this.get("reference"));
    }

    public String getTopic() {
        return this.get("Thema");
    }

    public String getText() {
        return this.get("text");
    }

    @Override
    public String getLabel() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getDate()).append(",").append(this.getTime()).append(": ").append(this.get("Thema")).append(" (").append(this.getAuthor().getLabel()).append(")");
        return ret.toString();
    }

    @Override
    protected String getTableName() {
        return "BBS";
    }

    protected BBSEntry() {
    }

    protected BBSEntry(String id) {
        super(id);
    }

    public static BBSEntry load(String id) {
        return new BBSEntry(id);
    }

    public String getDate() {
        return this.get("datum");
    }

    public String getTime() {
        String t = this.get("time");
        if (StringTool.isNothing((Object)t)) {
            return "00:00";
        }
        return String.valueOf(t.substring(0, 2)) + ":" + t.substring(2);
    }
}

