/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.cache;

import ch.elexis.core.data.cache.IPersistentObjectCache;
import ch.rgw.tools.Log;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SoftCache<K>
implements IPersistentObjectCache<K> {
    private static boolean enabled = true;
    protected Map<K, CacheEntry> cache;
    protected long hits;
    protected long misses;
    protected long removed;
    protected long inserts;
    protected long expired;
    protected Log log = Log.get((String)SoftCache.class.getName());

    public SoftCache() {
        this.cache = Collections.synchronizedMap(new HashMap());
    }

    public SoftCache(int num, float load) {
        this.cache = Collections.synchronizedMap(new HashMap(num, load));
    }

    public SoftCache(int num) {
        this.cache = Collections.synchronizedMap(new HashMap(num));
    }

    @Override
    public void put(K key, Object object, int timeToCacheInSeconds) {
        if (enabled) {
            this.cache.put(key, new CacheEntry(object, timeToCacheInSeconds));
            ++this.inserts;
        }
    }

    @Override
    public Object get(K key, int timeToCacheInSeconds) {
        return this.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(K key) {
        if (!enabled) {
            return null;
        }
        Map<K, CacheEntry> map = this.cache;
        synchronized (map) {
            Object ret;
            block7: {
                CacheEntry ref;
                block6: {
                    ref = this.cache.get(key);
                    if (ref != null) break block6;
                    ++this.misses;
                    return null;
                }
                ret = ref.get();
                if (ret != null) break block7;
                this.remove(key);
                return null;
            }
            ++this.hits;
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K key) {
        Map<K, CacheEntry> map = this.cache;
        synchronized (map) {
            this.cache.remove(key);
            ++this.removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<K, CacheEntry> map = this.cache;
        synchronized (map) {
            this.purge();
            this.cache.clear();
        }
    }

    @Override
    public void stat() {
        long total = this.hits + this.misses + this.removed + this.expired;
        if (total != 0L) {
            StringBuilder sb = new StringBuilder();
            sb.append("--------- cache statistics ------\n").append("Total read:\t").append(total).append("\n").append("cache hits:\t").append(this.hits).append(" (").append(this.hits * 100L / total).append("%)\n").append("object expired:\t").append(this.expired).append(" (").append(this.expired * 100L / total).append("%)\n").append("cache missed:\t").append(this.misses).append(" (").append(this.misses * 100L / total).append("%)\n").append("object removed:\t").append(this.removed).append(" (").append(this.removed * 100L / total).append("%)\n").append("Object inserts:\t").append(this.inserts).append("\n");
            this.log.log(sb.toString(), 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() {
        Map<K, CacheEntry> map = this.cache;
        synchronized (map) {
            Iterator<Map.Entry<K, CacheEntry>> it = this.cache.entrySet().iterator();
            long freeBefore = Runtime.getRuntime().freeMemory();
            while (it.hasNext()) {
                Map.Entry<K, CacheEntry> e = it.next();
                CacheEntry ce = e.getValue();
                ce.expires = 0L;
                ce.get();
                it.remove();
            }
        }
    }

    @Override
    public synchronized void reset() {
        this.purge();
        this.cache.clear();
    }

    public class CacheEntry
    extends SoftReference {
        long expires;

        public CacheEntry(Object obj, int timeInSeconds) {
            super(obj);
            this.expires = System.currentTimeMillis() + (long)(timeInSeconds * 1000);
        }

        @Override
        public synchronized Object get() {
            Object ret = super.get();
            if (System.currentTimeMillis() > this.expires) {
                ++SoftCache.this.expired;
                super.clear();
                ret = null;
            }
            return ret;
        }
    }
}

