/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.text.docx.util;

import at.medevit.elexis.text.docx.util.DocxUtil;
import at.medevit.elexis.text.docx.util.StyleInfo;
import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.docx4j.jaxb.Context;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Text;
import org.jvnet.jaxb2_commons.ppp.Child;

public class TextUtil {
    static ObjectFactory wmlObjectFactory = Context.getWmlObjectFactory();

    public static Object insertText(Object cursor, String text, int align, StyleInfo styleInfo) {
        if (cursor instanceof R) {
            return TextUtil.addText((R)cursor, text, styleInfo);
        }
        if (cursor instanceof Text) {
            return TextUtil.insertText(((Text)cursor).getParent(), text, align, styleInfo);
        }
        throw new IllegalStateException("Unknown cursor type [" + cursor + "]");
    }

    public static Object replaceText(Object cursor, String text, int align, StyleInfo styleInfo) {
        if (cursor instanceof R) {
            return TextUtil.replaceText((R)cursor, text, styleInfo);
        }
        if (cursor instanceof Text) {
            return TextUtil.replaceText(((Text)cursor).getParent(), text, align, styleInfo);
        }
        throw new IllegalStateException("Unknown cursor type [" + cursor + "]");
    }

    private static Object replaceText(R cursor, String text, StyleInfo styleInfo) {
        R ret = null;
        boolean cursorInTbl = DocxUtil.getParentTbl((Child)cursor) != null;
        List<String> newLineSplit = Arrays.asList(text.split("\n", -1));
        int i = 0;
        while (i < newLineSplit.size()) {
            if (i == 0) {
                ret = TextUtil.insertLine(cursor, newLineSplit.get(i), styleInfo);
            } else if (cursorInTbl) {
                P p = DocxUtil.appendParagraph(cursor);
                R r = DocxUtil.getOrCreateRun(p);
                r.setRPr(cursor.getRPr());
                TextUtil.insertLine(r, newLineSplit.get(i), styleInfo);
                cursor = r;
            } else {
                TextUtil.appendLine(cursor, newLineSplit.get(i), styleInfo);
            }
            ++i;
        }
        return ret;
    }

    private static R addText(R cursor, String text, StyleInfo styleInfo) {
        R ret = null;
        List<String> newLineSplit = Arrays.asList(text.split("\n", -1));
        int i = 0;
        while (i < newLineSplit.size()) {
            if (i == 0) {
                ret = DocxUtil.appendRun(cursor);
                TextUtil.insertLine(ret, newLineSplit.get(i), styleInfo);
                cursor = ret;
            } else {
                TextUtil.appendLine(cursor, newLineSplit.get(i), styleInfo);
            }
            ++i;
        }
        return ret;
    }

    private static R insertLine(R cursor, String line, StyleInfo styleInfo) {
        TextUtil.applyStyleInfo(cursor, styleInfo);
        Text text = DocxUtil.getOrCreateText(cursor);
        List<String> tabsSplit = Arrays.asList(line.split("\t", -1));
        if (tabsSplit.size() > 1) {
            int i = 0;
            while (i < tabsSplit.size()) {
                if (i == 0) {
                    text.setValue(tabsSplit.get(i));
                } else {
                    text = DocxUtil.appendTabbedText(cursor);
                    text.setValue(tabsSplit.get(i));
                }
                ++i;
            }
        } else {
            text.setValue(line);
        }
        return cursor;
    }

    private static R appendLine(R cursor, String line, StyleInfo styleInfo) {
        TextUtil.applyStyleInfo(cursor, styleInfo);
        Text text = DocxUtil.getNewLineText(cursor);
        List<String> tabsSplit = Arrays.asList(line.split("\t", -1));
        if (tabsSplit.size() > 1) {
            int i = 0;
            while (i < tabsSplit.size()) {
                if (i == 0) {
                    text.setValue(tabsSplit.get(i));
                } else {
                    text = DocxUtil.appendTabbedText(cursor);
                    text.setValue(tabsSplit.get(i));
                }
                ++i;
            }
        } else {
            text.setValue(line);
        }
        return cursor;
    }

    private static boolean applyStyleInfo(R r, StyleInfo styleInfo) {
        if (styleInfo.isStyleSet()) {
            RPr rpr = wmlObjectFactory.createRPr();
            styleInfo.applyTo(rpr);
            r.setRPr(rpr);
            return true;
        }
        return false;
    }

    public static boolean isMultiTextRun(R cursor) {
        ArrayList content = new ArrayList(cursor.getContent());
        int textCount = 0;
        Iterator iterator = content.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object nonJaxBObject = object = iterator.next();
            if (object instanceof JAXBElement) {
                nonJaxBObject = ((JAXBElement)object).getValue();
            }
            if (!(nonJaxBObject instanceof Text) || ++textCount <= 1) continue;
            return true;
        }
        return false;
    }

    public static void convertToSingleTextRun(R cursor) {
        while (TextUtil.isMultiTextRun(cursor)) {
            R newRun = DocxUtil.createRunBefore(cursor);
            TextUtil.transferFirstText(cursor, newRun);
        }
    }

    private static void transferFirstText(R from, R to) {
        ArrayList content = new ArrayList(from.getContent());
        Iterator iterator = content.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object nonJaxBObject = object = iterator.next();
            if (object instanceof JAXBElement) {
                nonJaxBObject = ((JAXBElement)object).getValue();
            }
            if (nonJaxBObject instanceof Text) {
                Text text = (Text)nonJaxBObject;
                to.getContent().add(text);
                text.setParent((Object)to);
                from.getContent().remove(object);
                break;
            }
            if (!(nonJaxBObject instanceof Child)) continue;
            to.getContent().add(nonJaxBObject);
            ((Child)nonJaxBObject).setParent((Object)to);
            from.getContent().remove(object);
        }
    }
}

