/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.text.docx.util;

import java.math.BigInteger;
import org.docx4j.jaxb.Context;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;

public class StyleInfo {
    static ObjectFactory wmlObjectFactory = Context.getWmlObjectFactory();
    private String fontName;
    private int fontStyle = -1;
    private float fontSize = -1.0f;
    private boolean styleSet = false;

    public void setFontStyle(int style) {
        this.styleSet = true;
        this.fontStyle = style;
    }

    public void setFontName(String name) {
        this.styleSet = true;
        this.fontName = name;
    }

    public void setFontSize(float size) {
        this.styleSet = true;
        this.fontSize = size;
    }

    public boolean isStyleSet() {
        return this.styleSet;
    }

    public void applyTo(RPr rpr) {
        if (this.fontName != null) {
            RFonts fonts = rpr.getRFonts();
            if (fonts == null) {
                fonts = wmlObjectFactory.createRFonts();
                fonts.setAscii(this.fontName);
                fonts.setHAnsi(this.fontName);
                fonts.setCs(this.fontName);
            }
            rpr.setRFonts(fonts);
        }
        if (this.fontSize != -1.0f) {
            HpsMeasure measure = wmlObjectFactory.createHpsMeasure();
            measure.setVal(BigInteger.valueOf((long)this.fontSize * 2L));
            rpr.setSz(measure);
            rpr.setSzCs(measure);
        }
        if (this.fontStyle != -1) {
            BooleanDefaultTrue bold = new BooleanDefaultTrue();
            if ((this.fontStyle & 1) != 0) {
                bold.setVal(Boolean.valueOf(true));
                rpr.setB(bold);
            } else {
                bold.setVal(Boolean.valueOf(false));
                rpr.setB(bold);
            }
        }
    }
}

