/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.text.docx.util;

import at.medevit.elexis.text.docx.util.TableUtil;
import jakarta.xml.bind.JAXBElement;
import java.math.BigInteger;
import java.util.List;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Text;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.slf4j.LoggerFactory;

public class DocxUtil {
    static ObjectFactory wmlObjectFactory = Context.getWmlObjectFactory();

    public static ContentAccessor getParentContentAccessor(Child child) {
        Object parent = child.getParent();
        if (parent instanceof ContentAccessor) {
            return (ContentAccessor)parent;
        }
        if (parent instanceof Child) {
            return DocxUtil.getParentContentAccessor((Child)parent);
        }
        return null;
    }

    public static P getParentP(Child child) {
        Object parent = child.getParent();
        if (parent instanceof P) {
            return (P)parent;
        }
        if (parent instanceof Child) {
            return DocxUtil.getParentP((Child)parent);
        }
        return null;
    }

    public static Tbl getParentTbl(Child child) {
        Object parent = child.getParent();
        if (parent instanceof Tbl) {
            return (Tbl)parent;
        }
        if (parent instanceof Child) {
            return DocxUtil.getParentTbl((Child)parent);
        }
        return null;
    }

    public static Text getOrCreateText(R r) {
        Text ret = DocxUtil.getLastText(r);
        if (ret == null) {
            ret = wmlObjectFactory.createText();
            JAXBElement textWrapped = wmlObjectFactory.createRT(ret);
            r.getContent().add(textWrapped);
            ret.setParent((Object)r);
        }
        return ret;
    }

    public static Text getNewLineText(R r) {
        DocxUtil.appendNewLine(r);
        return DocxUtil.appendText(r);
    }

    public static Text appendTabbedText(R r) {
        DocxUtil.appendTab(r);
        return DocxUtil.appendText(r);
    }

    private static Text appendText(R r) {
        Text ret = wmlObjectFactory.createText();
        JAXBElement textWrapped = wmlObjectFactory.createRT(ret);
        r.getContent().add(textWrapped);
        ret.setParent((Object)r);
        return ret;
    }

    public static R appendRun(R cursor) {
        ContentAccessor parent = DocxUtil.getParentContentAccessor((Child)cursor);
        int index = parent.getContent().indexOf(cursor);
        R r = wmlObjectFactory.createR();
        if (index != -1) {
            parent.getContent().add(index + 1, r);
        } else {
            parent.getContent().add(r);
        }
        r.setParent((Object)parent);
        r.setRPr(cursor.getRPr());
        return r;
    }

    public static P appendParagraph(R cursor) {
        P parentP = DocxUtil.getParentP((Child)cursor);
        ContentAccessor parent = DocxUtil.getParentContentAccessor((Child)parentP);
        int index = parent.getContent().indexOf(parentP);
        P p = wmlObjectFactory.createP();
        p.setPPr(parentP.getPPr());
        if (p.getPPr() != null && p.getPPr().getSpacing() == null) {
            PPrBase.Spacing spacing = wmlObjectFactory.createPPrBaseSpacing();
            spacing.setAfter(BigInteger.ZERO);
            p.getPPr().setSpacing(spacing);
        }
        if (index != -1) {
            parent.getContent().add(index + 1, p);
        } else {
            parent.getContent().add(p);
        }
        p.setParent((Object)parent);
        return p;
    }

    public static R getOrCreateRun(P p) {
        R ret = DocxUtil.getLastRun(p);
        if (ret == null) {
            R r = wmlObjectFactory.createR();
            p.getContent().add(r);
            r.setParent((Object)p);
            RPr rpr = wmlObjectFactory.createRPr();
            r.setRPr(rpr);
            rpr.setParent((Object)r);
            ret = r;
        }
        return ret;
    }

    public static R createRunBefore(R cursor) {
        P parentP = DocxUtil.getParentP((Child)cursor);
        int index = parentP.getContent().indexOf(cursor);
        R r = wmlObjectFactory.createR();
        parentP.getContent().add(index, r);
        r.setParent((Object)parentP);
        r.setRPr(cursor.getRPr());
        return r;
    }

    public static R getLastRun(P p) {
        R ret = null;
        List content = p.getContent();
        for (Object object : content) {
            if (object instanceof JAXBElement) {
                object = ((JAXBElement)object).getValue();
            }
            if (!(object instanceof R)) continue;
            ret = (R)object;
        }
        return ret;
    }

    private static void appendTab(R r) {
        List content = r.getContent();
        R.Tab rTab = wmlObjectFactory.createRTab();
        JAXBElement rtabWrapped = wmlObjectFactory.createRTab(rTab);
        content.add(rtabWrapped);
        rTab.setParent((Object)r);
    }

    private static void appendNewLine(R r) {
        List content = r.getContent();
        R.Cr rCr = wmlObjectFactory.createRCr();
        JAXBElement rcrWrapped = wmlObjectFactory.createRCr(rCr);
        content.add(rcrWrapped);
        rCr.setParent((Object)r);
    }

    public static Text getLastText(R r) {
        Text ret = null;
        List content = r.getContent();
        for (Object object : content) {
            if (object instanceof JAXBElement) {
                object = ((JAXBElement)object).getValue();
            }
            if (!(object instanceof Text)) continue;
            ret = (Text)object;
        }
        return ret;
    }

    public static int getDocumentWidth(WordprocessingMLPackage document) {
        PageDimensions pageDimensions;
        SectionWrapper section;
        int ret = DocxUtil.getWritableWidthTwips();
        if (!document.getDocumentModel().getSections().isEmpty() && (section = (SectionWrapper)document.getDocumentModel().getSections().get(0)) != null && (pageDimensions = section.getPageDimensions()) != null) {
            return pageDimensions.getWritableWidthTwips();
        }
        return ret;
    }

    private static int getWritableWidthTwips() {
        try {
            WordprocessingMLPackage wordPackage = WordprocessingMLPackage.createPackage();
            SectionWrapper section = (SectionWrapper)wordPackage.getDocumentModel().getSections().get(0);
            PageDimensions pageDimensions = section.getPageDimensions();
            return pageDimensions.getWritableWidthTwips();
        }
        catch (InvalidFormatException e) {
            LoggerFactory.getLogger(TableUtil.class).error("Error getting table width twips");
            return 0;
        }
    }

    public static void addAlign(PPr ppr, int align) {
        Jc jc = wmlObjectFactory.createJc();
        if (align == 16384) {
            jc.setVal(JcEnumeration.LEFT);
        } else if (align == 131072) {
            jc.setVal(JcEnumeration.RIGHT);
        } else if (align == 0x1000000) {
            jc.setVal(JcEnumeration.CENTER);
        }
        ppr.setJc(jc);
    }
}

