/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.text.docx.stax;

import ch.elexis.core.data.interfaces.text.ReplaceCallback;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.docx4j.openpackaging.parts.StAXHandlerAbstract;

public class RegexReplaceStAXHandler
extends StAXHandlerAbstract {
    private ReplaceCallback replaceCallback;
    private Pattern pattern;

    public RegexReplaceStAXHandler(String regex, ReplaceCallback replaceCallback) {
        this.replaceCallback = replaceCallback;
        this.pattern = Pattern.compile(regex);
    }

    public void handleCharacters(XMLStreamReader xmlr, XMLStreamWriter writer) throws XMLStreamException {
        StringBuilder sb = new StringBuilder();
        sb.append(xmlr.getTextCharacters(), xmlr.getTextStart(), xmlr.getTextLength());
        String wmlString = this.replace(sb.toString(), new StringBuilder()).toString();
        char[] charOut = wmlString.toCharArray();
        writer.writeCharacters(charOut, 0, charOut.length);
    }

    private StringBuilder replace(String wmlTemplateString, StringBuilder strB) {
        if (this.patternMatchesText(wmlTemplateString)) {
            return strB.append(this.replaceAll(wmlTemplateString));
        }
        return strB.append(wmlTemplateString);
    }

    private boolean patternMatchesText(String text) {
        Matcher matcher = this.pattern.matcher(text);
        return matcher.find();
    }

    private String replaceAll(String text) {
        String replaced = text;
        Matcher matcher = this.pattern.matcher(text);
        while (matcher.find()) {
            Object replacement = this.replaceCallback.replace(replaced.substring(matcher.start(), matcher.end()));
            if (replacement instanceof String) {
                replaced = matcher.replaceFirst((String)replacement);
            }
            matcher = this.pattern.matcher(replaced);
        }
        return replaced;
    }
}

