/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.text.docx;

import at.medevit.elexis.text.docx.print.PrintProcess;
import at.medevit.elexis.text.docx.print.ScriptInitializer;
import at.medevit.elexis.text.docx.stax.TextFindStAXHandler;
import at.medevit.elexis.text.docx.util.DocxUtil;
import at.medevit.elexis.text.docx.util.FindTextVisitor;
import at.medevit.elexis.text.docx.util.RegexTextVisitor;
import at.medevit.elexis.text.docx.util.StyleInfo;
import at.medevit.elexis.text.docx.util.TableUtil;
import at.medevit.elexis.text.docx.util.TextBoxUtil;
import at.medevit.elexis.text.docx.util.TextUtil;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.text.ReplaceCallback;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.preferences.Messages;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.views.textsystem.TextTemplatePrintSettings;
import ch.elexis.core.utils.CoreUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.docx4j.Docx4J;
import org.docx4j.TraversalUtil;
import org.docx4j.model.datastorage.migration.VariablePrepare;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.StAXHandlerInterface;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.wml.R;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Text;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class DocxTextPlugin
implements ITextPlugin {
    private static final String DOCX_PREF = "textplugins/docx/";
    public static final String PRINT_PROCESS_TIMEOUT = "textplugins/docx/printtimeout";
    public static final String PRINT_COMMAND_PREF = "textplugins/docx/printcommand";
    public static final String PRINTTOPRINTER_COMMAND_PREF = "textplugins/docx/printtoprintercommand";
    public static final String USE_PRINT_SCRIPT = "textplugins/docx/printcommand";
    private ITextPlugin.Parameter parameter;
    private static TextTemplatePrintSettings printSettings;
    private ITextPlugin.PageFormat format = ITextPlugin.PageFormat.USER;
    private WordprocessingMLPackage currentDocument;
    private Composite composite;
    private Button openButton;
    private StyleInfo currentStyleInfo = new StyleInfo();

    public ITextPlugin.PageFormat getFormat() {
        return this.format;
    }

    public void setFormat(ITextPlugin.PageFormat f) {
        this.format = f;
    }

    public void setParameter(ITextPlugin.Parameter parameter) {
        this.parameter = parameter;
    }

    public void setFocus() {
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.setFocus();
        }
    }

    public void dispose() {
        this.composite.dispose();
    }

    public void showMenu(boolean b) {
    }

    public void showToolbar(boolean b) {
    }

    public void setSaveOnFocusLost(boolean bSave) {
    }

    public boolean createEmptyDocument() {
        try {
            this.currentDocument = WordprocessingMLPackage.createPackage();
            if (this.openButton != null && !this.openButton.isDisposed()) {
                this.openButton.setEnabled(true);
            }
        }
        catch (InvalidFormatException e) {
            LoggerFactory.getLogger(this.getClass()).error("Erro creating document", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean loadFromByteArray(byte[] bs, boolean asTemplate) {
        if (this.checkTextPreferences()) {
            try {
                this.currentDocument = WordprocessingMLPackage.load((InputStream)new ByteArrayInputStream(bs));
                if (this.openButton != null && !this.openButton.isDisposed()) {
                    this.openButton.setEnabled(true);
                }
            }
            catch (Docx4JException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error loading from byte array [" + bs + "] size [" + bs.length + "]");
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean checkTextPreferences() {
        boolean editLocal = CoreHub.localCfg.get("briefe/Textmodul_Edit_Local", false);
        boolean externFile = ConfigServiceHolder.getGlobal((String)"briefe/Textmodul_Extern_File", (boolean)false);
        if (editLocal && externFile) {
            return true;
        }
        StringBuilder missingOptionText = new StringBuilder();
        if (!editLocal && !externFile) {
            missingOptionText.append("Es sind aktuell beide Optionen nicht aktiviert.");
        } else {
            missingOptionText.append("Die Option [");
            if (!editLocal) {
                missingOptionText.append(Messages.Texterstellung_texteditlocaldesc);
            } else if (!externFile) {
                missingOptionText.append("Brief extern speichern");
            }
            missingOptionText.append("] ist aktuell nicht aktiviert.");
        }
        return MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Warnung", (String)("Bei Benutzung der Docx-Document Textausgabe wird empfohlen unter Einstellungen > Textverarbeitung folgende Optionen zu aktivieren.\n\n* " + Messages.Texterstellung_texteditlocaldesc + "\n" + "* " + "Brief extern speichern" + "\n\n" + missingOptionText.toString() + "\n" + "Wollen Sie trotzdem weiter machen?"));
    }

    public boolean loadFromStream(InputStream is, boolean asTemplate) {
        try {
            this.currentDocument = WordprocessingMLPackage.load((InputStream)is);
            if (this.openButton != null && !this.openButton.isDisposed()) {
                this.openButton.setEnabled(true);
            }
        }
        catch (Docx4JException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error loading from stream [" + is + "]");
            return false;
        }
        return true;
    }

    public byte[] storeToByteArray() {
        if (this.currentDocument != null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    Docx4J.save((OpcPackage)this.currentDocument, (OutputStream)out, (int)1);
                    return out.toByteArray();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | Docx4JException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error writing to byte array");
                return null;
            }
        }
        return null;
    }

    public boolean insertTable(String text, int properties, String[][] contents, int[] columnSizes) {
        if (this.currentDocument != null) {
            FindTextVisitor visitor = new FindTextVisitor(text);
            TraversalUtil.visit((Object)this.currentDocument.getMainDocumentPart(), (TraversalUtilVisitor)visitor);
            List<Text> found = visitor.getFound();
            if (!found.isEmpty()) {
                for (Text foundText : found) {
                    foundText.setValue("");
                    R r = (R)foundText.getParent();
                    if (contents.length <= 0) continue;
                    Tbl table = TableUtil.insertTable(r, properties, contents, columnSizes, DocxUtil.getDocumentWidth(this.currentDocument), true);
                    TableUtil.addBorders(table, 1);
                }
                return true;
            }
        }
        return false;
    }

    public Object insertTextAt(int posx, int posy, int width, int height, String text, int align) {
        if (this.currentDocument != null) {
            return TextBoxUtil.createTextBox(this.currentDocument, posx - 3, posy, width, height, text, align, this.currentStyleInfo);
        }
        return null;
    }

    public boolean setFont(String name, int style, float size) {
        this.currentStyleInfo.setFontName(name);
        this.currentStyleInfo.setFontStyle(style);
        this.currentStyleInfo.setFontSize(size);
        return true;
    }

    public boolean setStyle(int style) {
        this.currentStyleInfo.setFontStyle(style);
        return true;
    }

    public Object insertText(String marke, String text, int align) {
        if (this.currentDocument != null) {
            FindTextVisitor visitor = new FindTextVisitor(marke);
            TraversalUtil.visit((Object)this.currentDocument.getMainDocumentPart(), (TraversalUtilVisitor)visitor);
            List<Text> found = visitor.getFound();
            if (!found.isEmpty()) {
                Object ret = null;
                for (Text foundText : found) {
                    foundText.setValue("");
                    R r = (R)foundText.getParent();
                    ret = TextUtil.insertText(r, text, align, this.currentStyleInfo);
                }
                return ret;
            }
        }
        return null;
    }

    public Object insertText(Object pos, String text, int align) {
        return TextUtil.insertText(pos, text, align, this.currentStyleInfo);
    }

    public boolean clear() {
        return false;
    }

    public boolean print(String toPrinter, String toTray, boolean waitUntilFinished) {
        if (this.currentDocument != null) {
            if (CoreUtil.isWindows() && ConfigServiceHolder.getGlobal((String)"textplugins/docx/printcommand", (boolean)false) && !this.isScriptWinInitialized()) {
                this.initializeScriptWin();
            }
            if (printSettings != null) {
                toPrinter = printSettings.getPrinter() == null ? toPrinter : printSettings.getPrinter();
                toTray = printSettings.getTray() == null ? toTray : printSettings.getTray();
            }
            String printCommand = null;
            printCommand = toPrinter != null && !toPrinter.isEmpty() ? this.getPrintPrinterCommand() : this.getPrintNoPrinterCommand();
            if (printCommand != null) {
                Optional<File> tempFile = this.getCurrentDocumentTempFile();
                if (tempFile.isPresent()) {
                    PrintProcess process = new PrintProcess(printCommand);
                    process.setPrinter(toPrinter);
                    process.setTray(toTray);
                    process.setFilename(tempFile.get().getAbsolutePath());
                    return process.execute();
                }
            } else {
                this.openCurrentDocument();
            }
            return true;
        }
        return false;
    }

    public void initTemplatePrintSettings(String template) {
        printSettings = new TextTemplatePrintSettings(template, this.getMimeType());
    }

    private String getPrintNoPrinterCommand() {
        Properties commandsProperties;
        if (CoreUtil.isWindows() && ConfigServiceHolder.getGlobal((String)"textplugins/docx/printcommand", (boolean)false) && (commandsProperties = ScriptInitializer.getPrintCommands("/rsc/script/win/printcommands.properties")) != null && commandsProperties.get("noprinter") != null) {
            return (String)commandsProperties.get("noprinter");
        }
        return CoreHub.localCfg.get("textplugins/docx/printcommand", null);
    }

    private String getPrintPrinterCommand() {
        Properties commandsProperties;
        if (CoreUtil.isWindows() && ConfigServiceHolder.getGlobal((String)"textplugins/docx/printcommand", (boolean)false) && (commandsProperties = ScriptInitializer.getPrintCommands("/rsc/script/win/printcommands.properties")) != null && commandsProperties.get("printer") != null) {
            return (String)commandsProperties.get("printer");
        }
        return CoreHub.localCfg.get(PRINTTOPRINTER_COMMAND_PREF, null);
    }

    private void openCurrentDocument() {
        if (this.currentDocument != null) {
            Optional<File> tempFile = this.getCurrentDocumentTempFile();
            tempFile.ifPresent(f -> {
                LoggerFactory.getLogger(this.getClass()).debug("Open temporary document from [" + f.getAbsolutePath() + "]");
                Program.launch((String)f.getAbsolutePath());
            });
        }
    }

    private Optional<File> getCurrentDocumentTempFile() {
        try {
            File tempFile = File.createTempFile("dtp_", "_" + System.currentTimeMillis() + ".docx");
            tempFile.deleteOnExit();
            Docx4J.save((OpcPackage)this.currentDocument, (File)tempFile, (int)1);
            return Optional.of(tempFile);
        }
        catch (IOException | Docx4JException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error saving docx temp file", e);
            return Optional.empty();
        }
    }

    public String getMimeType() {
        return "docx";
    }

    public boolean isDirectOutput() {
        return false;
    }

    public Composite createContainer(Composite parent, ITextPlugin.ICallback handler) {
        if (this.composite == null) {
            this.composite = new Composite(parent, 0);
            RowLayout layout = new RowLayout(512);
            layout.wrap = true;
            layout.fill = false;
            layout.justify = false;
            layout.marginBottom = 9;
            this.composite.setLayout((Layout)layout);
            RowData data = new RowData();
            Label label = new Label(this.composite, 8);
            label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
            label.setText("docx Dokumente Generator ohne Editor\n");
            label.setLayoutData((Object)data);
            data.width = 400;
            this.openButton = new Button(this.composite, 8);
            this.openButton.setText("Dokument \u00f6ffnen");
            this.openButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DocxTextPlugin.this.openCurrentDocument();
                }
            });
            data = new RowData();
            this.openButton.setLayoutData((Object)data);
            this.openButton.setEnabled(false);
            this.composite.pack();
        }
        return this.composite;
    }

    public boolean findOrReplace(String pattern, ReplaceCallback callBack) {
        if (this.currentDocument != null) {
            this.prepare();
            MainDocumentPart documentPart = this.currentDocument.getMainDocumentPart();
            RegexTextVisitor visitor = new RegexTextVisitor(this.currentDocument, pattern);
            TraversalUtil.visit((Object)documentPart, (TraversalUtilVisitor)visitor);
            visitor.replaceMatchingTexts(callBack);
            RelationshipsPart relationshipPart = documentPart.getRelationshipsPart();
            List relationships = relationshipPart.getRelationships().getRelationship();
            for (Relationship relationship : relationships) {
                if (!relationship.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header") && !relationship.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
                JaxbXmlPart part = (JaxbXmlPart)relationshipPart.getPart(relationship);
                RegexTextVisitor partVisitor = new RegexTextVisitor(this.currentDocument, pattern);
                TraversalUtil.visit((Object)part, (TraversalUtilVisitor)partVisitor);
                partVisitor.replaceMatchingTexts(callBack);
            }
        }
        return false;
    }

    protected int findTextCount(String text) {
        if (this.currentDocument != null) {
            try {
                this.prepare();
                TextFindStAXHandler stAXHAndler = new TextFindStAXHandler(text);
                MainDocumentPart documentPart = this.currentDocument.getMainDocumentPart();
                RelationshipsPart relationshipPart = documentPart.getRelationshipsPart();
                List relationships = relationshipPart.getRelationships().getRelationship();
                for (Relationship relationship : relationships) {
                    if (!relationship.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header") && !relationship.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
                    JaxbXmlPart part = (JaxbXmlPart)relationshipPart.getPart(relationship);
                    part.pipe((StAXHandlerInterface)stAXHAndler);
                }
                documentPart.pipe((StAXHandlerInterface)stAXHAndler);
                return stAXHAndler.getCount();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("Error finding text [" + text + "]", (Throwable)e);
            }
        }
        return 0;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public WordprocessingMLPackage getCurrentDocument() {
        return this.currentDocument;
    }

    protected void prepare() {
        if (this.currentDocument != null) {
            try {
                VariablePrepare.prepare((WordprocessingMLPackage)this.currentDocument);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("Error preparing document", (Throwable)e);
            }
        }
    }

    private boolean isScriptWinInitialized() {
        ScriptInitializer initializer = new ScriptInitializer("/rsc/script/win/doc2sumatraprint.ps1");
        if (!initializer.existsInScriptFolder()) {
            return false;
        }
        if (!initializer.matchingFileSize()) {
            return false;
        }
        initializer = new ScriptInitializer("/rsc/script/win/SumatraPDF.exe");
        if (!initializer.existsInScriptFolder()) {
            return false;
        }
        return initializer.matchingFileSize();
    }

    private void initializeScriptWin() {
        ScriptInitializer initializer = new ScriptInitializer("/rsc/script/win/doc2sumatraprint.ps1");
        if (initializer.existsInScriptFolder()) {
            if (MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Script existiert bereits", (String)("Script [" + initializer.getFilename() + "] existiert bereits, soll die Datei \u00fcberschrieben werden?"))) {
                initializer.init();
            }
        } else {
            initializer.init();
        }
        if ((initializer = new ScriptInitializer("/rsc/script/win/SumatraPDF.exe")).existsInScriptFolder()) {
            if (MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Script existiert bereits", (String)("Script [" + initializer.getFilename() + "] existiert bereits, soll die Datei \u00fcberschrieben werden?"))) {
                initializer.init();
            }
        } else {
            initializer.init();
        }
    }
}

